package io.resys.hdes.client.spi;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.hdes.client.api.ast.AstCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GitStore.BatchEntry}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBatchEntry.builder()}.
 */
@Generated(from = "GitStore.BatchEntry", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableBatchEntry implements GitStore.BatchEntry {
  private final GitConfig.GitFile file;
  private final ImmutableList<AstCommand> body;

  private ImmutableBatchEntry(
      GitConfig.GitFile file,
      ImmutableList<AstCommand> body) {
    this.file = file;
    this.body = body;
  }

  /**
   * @return The value of the {@code file} attribute
   */
  @Override
  public GitConfig.GitFile getFile() {
    return file;
  }

  /**
   * @return The value of the {@code body} attribute
   */
  @Override
  public ImmutableList<AstCommand> getBody() {
    return body;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitStore.BatchEntry#getFile() file} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for file
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBatchEntry withFile(GitConfig.GitFile value) {
    if (this.file == value) return this;
    GitConfig.GitFile newValue = Objects.requireNonNull(value, "file");
    return new ImmutableBatchEntry(newValue, this.body);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GitStore.BatchEntry#getBody() body}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchEntry withBody(AstCommand... elements) {
    ImmutableList<AstCommand> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchEntry(this.file, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GitStore.BatchEntry#getBody() body}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of body elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchEntry withBody(Iterable<? extends AstCommand> elements) {
    if (this.body == elements) return this;
    ImmutableList<AstCommand> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBatchEntry(this.file, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBatchEntry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBatchEntry
        && equalTo((ImmutableBatchEntry) another);
  }

  private boolean equalTo(ImmutableBatchEntry another) {
    return file.equals(another.file)
        && body.equals(another.body);
  }

  /**
   * Computes a hash code from attributes: {@code file}, {@code body}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + file.hashCode();
    h += (h << 5) + body.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BatchEntry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BatchEntry")
        .omitNullValues()
        .add("file", file)
        .add("body", body)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GitStore.BatchEntry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BatchEntry instance
   */
  public static ImmutableBatchEntry copyOf(GitStore.BatchEntry instance) {
    if (instance instanceof ImmutableBatchEntry) {
      return (ImmutableBatchEntry) instance;
    }
    return ImmutableBatchEntry.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBatchEntry ImmutableBatchEntry}.
   * <pre>
   * ImmutableBatchEntry.builder()
   *    .file(io.resys.hdes.client.spi.GitConfig.GitFile) // required {@link GitStore.BatchEntry#getFile() file}
   *    .addBody|addAllBody(io.resys.hdes.client.api.ast.AstCommand) // {@link GitStore.BatchEntry#getBody() body} elements
   *    .build();
   * </pre>
   * @return A new ImmutableBatchEntry builder
   */
  public static ImmutableBatchEntry.Builder builder() {
    return new ImmutableBatchEntry.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBatchEntry ImmutableBatchEntry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GitStore.BatchEntry", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FILE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable GitConfig.GitFile file;
    private ImmutableList.Builder<AstCommand> body = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BatchEntry} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GitStore.BatchEntry instance) {
      Objects.requireNonNull(instance, "instance");
      file(instance.getFile());
      addAllBody(instance.getBody());
      return this;
    }

    /**
     * Initializes the value for the {@link GitStore.BatchEntry#getFile() file} attribute.
     * @param file The value for file 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder file(GitConfig.GitFile file) {
      this.file = Objects.requireNonNull(file, "file");
      initBits &= ~INIT_BIT_FILE;
      return this;
    }

    /**
     * Adds one element to {@link GitStore.BatchEntry#getBody() body} list.
     * @param element A body element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBody(AstCommand element) {
      this.body.add(element);
      return this;
    }

    /**
     * Adds elements to {@link GitStore.BatchEntry#getBody() body} list.
     * @param elements An array of body elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBody(AstCommand... elements) {
      this.body.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GitStore.BatchEntry#getBody() body} list.
     * @param elements An iterable of body elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder body(Iterable<? extends AstCommand> elements) {
      this.body = ImmutableList.builder();
      return addAllBody(elements);
    }

    /**
     * Adds elements to {@link GitStore.BatchEntry#getBody() body} list.
     * @param elements An iterable of body elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllBody(Iterable<? extends AstCommand> elements) {
      this.body.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableBatchEntry ImmutableBatchEntry}.
     * @return An immutable instance of BatchEntry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBatchEntry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBatchEntry(file, body.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FILE) != 0) attributes.add("file");
      return "Cannot build BatchEntry, some of required attributes are not set " + attributes;
    }
  }
}
