package io.resys.hdes.client.spi;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GitConfig.GitInit}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGitInit.builder()}.
 */
@Generated(from = "GitConfig.GitInit", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGitInit implements GitConfig.GitInit {
  private final String branch;
  private final String remote;
  private final String sshPath;
  private final String storage;

  private ImmutableGitInit(
      String branch,
      String remote,
      String sshPath,
      String storage) {
    this.branch = branch;
    this.remote = remote;
    this.sshPath = sshPath;
    this.storage = storage;
  }

  /**
   * @return The value of the {@code branch} attribute
   */
  @Override
  public String getBranch() {
    return branch;
  }

  /**
   * @return The value of the {@code remote} attribute
   */
  @Override
  public String getRemote() {
    return remote;
  }

  /**
   * @return The value of the {@code sshPath} attribute
   */
  @Override
  public String getSshPath() {
    return sshPath;
  }

  /**
   * @return The value of the {@code storage} attribute
   */
  @Override
  public String getStorage() {
    return storage;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitInit#getBranch() branch} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for branch
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitInit withBranch(String value) {
    String newValue = Objects.requireNonNull(value, "branch");
    if (this.branch.equals(newValue)) return this;
    return new ImmutableGitInit(newValue, this.remote, this.sshPath, this.storage);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitInit#getRemote() remote} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for remote
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitInit withRemote(String value) {
    String newValue = Objects.requireNonNull(value, "remote");
    if (this.remote.equals(newValue)) return this;
    return new ImmutableGitInit(this.branch, newValue, this.sshPath, this.storage);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitInit#getSshPath() sshPath} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sshPath
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitInit withSshPath(String value) {
    String newValue = Objects.requireNonNull(value, "sshPath");
    if (this.sshPath.equals(newValue)) return this;
    return new ImmutableGitInit(this.branch, this.remote, newValue, this.storage);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitInit#getStorage() storage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for storage
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitInit withStorage(String value) {
    String newValue = Objects.requireNonNull(value, "storage");
    if (this.storage.equals(newValue)) return this;
    return new ImmutableGitInit(this.branch, this.remote, this.sshPath, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGitInit} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGitInit
        && equalTo((ImmutableGitInit) another);
  }

  private boolean equalTo(ImmutableGitInit another) {
    return branch.equals(another.branch)
        && remote.equals(another.remote)
        && sshPath.equals(another.sshPath)
        && storage.equals(another.storage);
  }

  /**
   * Computes a hash code from attributes: {@code branch}, {@code remote}, {@code sshPath}, {@code storage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + branch.hashCode();
    h += (h << 5) + remote.hashCode();
    h += (h << 5) + sshPath.hashCode();
    h += (h << 5) + storage.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GitInit} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GitInit")
        .omitNullValues()
        .add("branch", branch)
        .add("remote", remote)
        .add("sshPath", sshPath)
        .add("storage", storage)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GitConfig.GitInit} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GitInit instance
   */
  public static ImmutableGitInit copyOf(GitConfig.GitInit instance) {
    if (instance instanceof ImmutableGitInit) {
      return (ImmutableGitInit) instance;
    }
    return ImmutableGitInit.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGitInit ImmutableGitInit}.
   * <pre>
   * ImmutableGitInit.builder()
   *    .branch(String) // required {@link GitConfig.GitInit#getBranch() branch}
   *    .remote(String) // required {@link GitConfig.GitInit#getRemote() remote}
   *    .sshPath(String) // required {@link GitConfig.GitInit#getSshPath() sshPath}
   *    .storage(String) // required {@link GitConfig.GitInit#getStorage() storage}
   *    .build();
   * </pre>
   * @return A new ImmutableGitInit builder
   */
  public static ImmutableGitInit.Builder builder() {
    return new ImmutableGitInit.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGitInit ImmutableGitInit}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GitConfig.GitInit", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BRANCH = 0x1L;
    private static final long INIT_BIT_REMOTE = 0x2L;
    private static final long INIT_BIT_SSH_PATH = 0x4L;
    private static final long INIT_BIT_STORAGE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String branch;
    private @Nullable String remote;
    private @Nullable String sshPath;
    private @Nullable String storage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GitInit} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GitConfig.GitInit instance) {
      Objects.requireNonNull(instance, "instance");
      branch(instance.getBranch());
      remote(instance.getRemote());
      sshPath(instance.getSshPath());
      storage(instance.getStorage());
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitInit#getBranch() branch} attribute.
     * @param branch The value for branch 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder branch(String branch) {
      this.branch = Objects.requireNonNull(branch, "branch");
      initBits &= ~INIT_BIT_BRANCH;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitInit#getRemote() remote} attribute.
     * @param remote The value for remote 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder remote(String remote) {
      this.remote = Objects.requireNonNull(remote, "remote");
      initBits &= ~INIT_BIT_REMOTE;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitInit#getSshPath() sshPath} attribute.
     * @param sshPath The value for sshPath 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sshPath(String sshPath) {
      this.sshPath = Objects.requireNonNull(sshPath, "sshPath");
      initBits &= ~INIT_BIT_SSH_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitInit#getStorage() storage} attribute.
     * @param storage The value for storage 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder storage(String storage) {
      this.storage = Objects.requireNonNull(storage, "storage");
      initBits &= ~INIT_BIT_STORAGE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGitInit ImmutableGitInit}.
     * @return An immutable instance of GitInit
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGitInit build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGitInit(branch, remote, sshPath, storage);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BRANCH) != 0) attributes.add("branch");
      if ((initBits & INIT_BIT_REMOTE) != 0) attributes.add("remote");
      if ((initBits & INIT_BIT_SSH_PATH) != 0) attributes.add("sshPath");
      if ((initBits & INIT_BIT_STORAGE) != 0) attributes.add("storage");
      return "Cannot build GitInit, some of required attributes are not set " + attributes;
    }
  }
}
