/*
 * Decompiled with CFR 0.152.
 */
package io.resys.wrench.assets.bundle.spi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.resys.hdes.client.api.HdesAstTypes;
import io.resys.hdes.client.api.ast.FlowAstType;
import io.resys.hdes.client.api.execution.DecisionTableResult;
import io.resys.hdes.client.api.execution.Service;
import io.resys.hdes.client.api.model.FlowModel;
import io.resys.hdes.client.spi.HdesAstTypesImpl;
import io.resys.hdes.client.spi.decision.GenericExpressionExecutor;
import io.resys.hdes.client.spi.decision.SpringDynamicValueExpressionExecutor;
import io.resys.wrench.assets.bundle.api.repositories.AssetServiceRepository;
import io.resys.wrench.assets.bundle.spi.builders.GenericServiceQuery;
import io.resys.wrench.assets.bundle.spi.clock.ClockRepository;
import io.resys.wrench.assets.bundle.spi.clock.SystemClockRepository;
import io.resys.wrench.assets.bundle.spi.dt.DtServiceBuilder;
import io.resys.wrench.assets.bundle.spi.flow.FlowServiceBuilder;
import io.resys.wrench.assets.bundle.spi.flow.FlowServiceDataModelValidator;
import io.resys.wrench.assets.bundle.spi.flow.executors.GenericFlowDtExecutor;
import io.resys.wrench.assets.bundle.spi.flow.executors.GenericFlowServiceExecutor;
import io.resys.wrench.assets.bundle.spi.flow.executors.VariableResolver;
import io.resys.wrench.assets.bundle.spi.flow.hints.PartialTaskInputsAutocomplete;
import io.resys.wrench.assets.bundle.spi.flow.hints.TaskInputMappingAutocomplete;
import io.resys.wrench.assets.bundle.spi.flow.hints.TaskInputsAutocomplete;
import io.resys.wrench.assets.bundle.spi.flow.hints.TaskRefAutocomplete;
import io.resys.wrench.assets.bundle.spi.flowtask.FlowTaskServiceBuilder;
import io.resys.wrench.assets.bundle.spi.postprocessors.FlowDependencyServicePostProcessor;
import io.resys.wrench.assets.bundle.spi.postprocessors.GenericServicePostProcessorSupplier;
import io.resys.wrench.assets.bundle.spi.postprocessors.ListServicePostProcessor;
import io.resys.wrench.assets.bundle.spi.repositories.GenericAssetServiceRepository;
import io.resys.wrench.assets.bundle.spi.store.AssetLocation;
import io.resys.wrench.assets.bundle.spi.store.GenericServiceIdGen;
import io.resys.wrench.assets.bundle.spi.store.ListAssetLoader;
import io.resys.wrench.assets.bundle.spi.store.PostProcessingServiceStore;
import io.resys.wrench.assets.bundle.spi.tag.TagServiceBuilder;
import io.resys.wrench.assets.context.config.AssetConfigBean;
import io.resys.wrench.assets.context.config.GitConfigBean;
import io.resys.wrench.assets.dt.api.DecisionTableRepository;
import io.resys.wrench.assets.dt.spi.GenericDecisionTableRepository;
import io.resys.wrench.assets.flow.api.FlowExecutorRepository;
import io.resys.wrench.assets.flow.api.FlowRepository;
import io.resys.wrench.assets.flow.spi.GenericFlowExecutorFactory;
import io.resys.wrench.assets.flow.spi.GenericFlowRepository;
import io.resys.wrench.assets.flow.spi.executors.EmptyFlowTaskExecutor;
import io.resys.wrench.assets.flow.spi.executors.EndFlowTaskExecutor;
import io.resys.wrench.assets.flow.spi.executors.ExclusiveFlowTaskExecutor;
import io.resys.wrench.assets.flow.spi.executors.MergeFlowTaskExecutor;
import io.resys.wrench.assets.flow.spi.expressions.ExpressionFactory;
import io.resys.wrench.assets.flow.spi.expressions.SpelExpressionFactory;
import io.resys.wrench.assets.flow.spi.hints.DescAutocomplete;
import io.resys.wrench.assets.flow.spi.hints.IdAutocomplete;
import io.resys.wrench.assets.flow.spi.hints.input.InputAutocomplete;
import io.resys.wrench.assets.flow.spi.hints.input.InputDataTypeAutocomplete;
import io.resys.wrench.assets.flow.spi.hints.input.InputDebugValueAutocomplete;
import io.resys.wrench.assets.flow.spi.hints.input.InputRequiredAutocomplete;
import io.resys.wrench.assets.flow.spi.hints.input.InputsAutocomplete;
import io.resys.wrench.assets.flow.spi.hints.task.SwitchAutocomplete;
import io.resys.wrench.assets.flow.spi.hints.task.SwitchBodyAutocomplete;
import io.resys.wrench.assets.flow.spi.hints.task.TaskAutocomplete;
import io.resys.wrench.assets.flow.spi.hints.task.TaskCollectionAutocomplete;
import io.resys.wrench.assets.flow.spi.hints.task.TaskThenAutocomplete;
import io.resys.wrench.assets.flow.spi.hints.task.TasksAutocomplete;
import io.resys.wrench.assets.flow.spi.validators.DescriptionValidator;
import io.resys.wrench.assets.flow.spi.validators.IdValidator;
import io.resys.wrench.assets.script.api.ScriptRepository;
import io.resys.wrench.assets.script.spi.GenericScriptRepository;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@Configuration
@EnableConfigurationProperties(value={GitConfigBean.class, AssetConfigBean.class})
public class AssetComponentConfiguration {
    private final ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    @Bean
    public AssetServiceRepository assetServiceRepository(final ApplicationContext context, ObjectMapper objectMapper, AssetConfigBean assetConfigBean, AssetServiceRepository.ServiceStore origServiceStore) {
        SystemClockRepository clockRepository = new SystemClockRepository();
        HdesAstTypesImpl dataTypeRepository = new HdesAstTypesImpl(objectMapper);
        DecisionTableRepository decisionTableRepository = this.decisionTableRepository((HdesAstTypes)dataTypeRepository, objectMapper, origServiceStore);
        FlowRepository flowRepository = this.flowRepository((HdesAstTypes)dataTypeRepository, (ClockRepository)clockRepository, origServiceStore, objectMapper);
        ScriptRepository scriptRepository = this.scriptRepository(objectMapper, (HdesAstTypes)dataTypeRepository, context);
        Service.ServiceInit init = new Service.ServiceInit(){

            public <T> T get(Class<T> type) {
                return (T)context.getAutowireCapableBeanFactory().createBean(type);
            }
        };
        GenericServiceIdGen idGen = new GenericServiceIdGen();
        HashMap<AssetServiceRepository.ServiceType, Function<AssetServiceRepository.ServiceStore, AssetServiceRepository.ServiceBuilder>> builders = new HashMap<AssetServiceRepository.ServiceType, Function<AssetServiceRepository.ServiceStore, AssetServiceRepository.ServiceBuilder>>();
        builders.put(AssetServiceRepository.ServiceType.DT, arg_0 -> this.lambda$assetServiceRepository$0((AssetServiceRepository.ServiceIdGen)idGen, decisionTableRepository, (ClockRepository)clockRepository, arg_0));
        builders.put(AssetServiceRepository.ServiceType.FLOW, arg_0 -> this.lambda$assetServiceRepository$1((AssetServiceRepository.ServiceIdGen)idGen, flowRepository, (ClockRepository)clockRepository, arg_0));
        builders.put(AssetServiceRepository.ServiceType.FLOW_TASK, arg_0 -> this.lambda$assetServiceRepository$2((AssetServiceRepository.ServiceIdGen)idGen, init, scriptRepository, objectMapper, arg_0));
        builders.put(AssetServiceRepository.ServiceType.TAG, arg_0 -> this.lambda$assetServiceRepository$3(assetConfigBean, (AssetServiceRepository.ServiceIdGen)idGen, arg_0));
        HashMap<AssetServiceRepository.ServiceType, Object> postProcessors = new HashMap<AssetServiceRepository.ServiceType, Object>();
        postProcessors.put(AssetServiceRepository.ServiceType.FLOW_TASK, new FlowDependencyServicePostProcessor(builders));
        postProcessors.put(AssetServiceRepository.ServiceType.DT, new FlowDependencyServicePostProcessor(builders));
        postProcessors.put(AssetServiceRepository.ServiceType.DATA_TYPE, new ListServicePostProcessor(new AssetServiceRepository.ServicePostProcessor[]{new FlowDependencyServicePostProcessor(builders)}));
        GenericServicePostProcessorSupplier servicePostProcessorSupplier = new GenericServicePostProcessorSupplier(postProcessors);
        PostProcessingServiceStore serviceStore = new PostProcessingServiceStore(origServiceStore, (AssetServiceRepository.ServicePostProcessorSupplier)servicePostProcessorSupplier);
        return new GenericAssetServiceRepository((HdesAstTypes)dataTypeRepository, objectMapper, decisionTableRepository, flowRepository, scriptRepository, builders, (AssetServiceRepository.ServiceStore)serviceStore);
    }

    @Bean
    public Loader loader(AssetLocation location, AssetServiceRepository assetRepository) {
        return new Loader(location, assetRepository);
    }

    private DecisionTableRepository decisionTableRepository(HdesAstTypes dataTypeRepository, ObjectMapper objectMapper, AssetServiceRepository.ServiceStore serviceStore) {
        GenericExpressionExecutor expressionExecutor = new GenericExpressionExecutor(objectMapper);
        return new GenericDecisionTableRepository(objectMapper, dataTypeRepository, (DecisionTableResult.NodeExpressionExecutor)expressionExecutor, () -> new SpringDynamicValueExpressionExecutor());
    }

    private FlowRepository flowRepository(HdesAstTypes dataTypeRepository, ClockRepository clockRepository, AssetServiceRepository.ServiceStore serviceStore, ObjectMapper objectMapper) {
        SpelExpressionFactory parser = new SpelExpressionFactory();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        List<FlowAstType.NodeFlowVisitor> visitors = Arrays.asList(new IdAutocomplete(), new DescAutocomplete(), new InputsAutocomplete(), new TasksAutocomplete(), new TaskThenAutocomplete(), new TaskRefAutocomplete(serviceStore), new InputRequiredAutocomplete(), new InputDataTypeAutocomplete(), new InputAutocomplete(), new TaskAutocomplete(), new TaskCollectionAutocomplete(), new TaskInputsAutocomplete(serviceStore), new PartialTaskInputsAutocomplete(serviceStore), new SwitchAutocomplete(), new InputDebugValueAutocomplete(), new SwitchBodyAutocomplete(), new TaskInputMappingAutocomplete(serviceStore), new IdValidator(), new DescriptionValidator(), new FlowServiceDataModelValidator(serviceStore, dataTypeRepository));
        VariableResolver variableResolver = new VariableResolver(objectMapper);
        HashMap<FlowModel.FlowTaskType, Object> executors = new HashMap<FlowModel.FlowTaskType, Object>();
        executors.put(FlowModel.FlowTaskType.END, new EndFlowTaskExecutor());
        executors.put(FlowModel.FlowTaskType.EXCLUSIVE, new ExclusiveFlowTaskExecutor());
        executors.put(FlowModel.FlowTaskType.MERGE, new MergeFlowTaskExecutor());
        executors.put(FlowModel.FlowTaskType.SERVICE, new GenericFlowServiceExecutor(serviceStore, variableResolver));
        executors.put(FlowModel.FlowTaskType.DT, new GenericFlowDtExecutor(() -> new GenericServiceQuery(serviceStore), variableResolver));
        executors.put(FlowModel.FlowTaskType.EMPTY, new EmptyFlowTaskExecutor());
        GenericFlowExecutorFactory executorRepository = new GenericFlowExecutorFactory(executors);
        return new GenericFlowRepository(dataTypeRepository, (FlowExecutorRepository)executorRepository, (ExpressionFactory)parser, objectMapper, clockRepository.get());
    }

    private ScriptRepository scriptRepository(ObjectMapper objectMapper, HdesAstTypes dataTypeRepository, ApplicationContext context) {
        return new GenericScriptRepository(dataTypeRepository, objectMapper);
    }

    protected String getDefaultContent(AssetServiceRepository.ServiceType type) {
        try {
            String location = this.getDefaultContentPattern(type);
            Resource resource = this.resolver.getResource(location);
            return IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected String getDefaultContentPattern(AssetServiceRepository.ServiceType type) {
        switch (type) {
            case DT: {
                return "classpath:defaults/default-dt.json";
            }
            case FLOW: {
                return "classpath:defaults/default-flow.json";
            }
            case FLOW_TASK: {
                return "classpath:defaults/default-flowtask.json";
            }
            case TAG: {
                return "classpath:defaults/default-tag.json";
            }
            case DATA_TYPE: {
                return "classpath:defaults/default-datatype.yaml";
            }
        }
        throw new IllegalArgumentException("No default content for service type: " + type + "!");
    }

    private /* synthetic */ AssetServiceRepository.ServiceBuilder lambda$assetServiceRepository$3(AssetConfigBean assetConfigBean, AssetServiceRepository.ServiceIdGen idGen, AssetServiceRepository.ServiceStore store) {
        return new TagServiceBuilder(assetConfigBean.getTagFormat(), idGen, this.getDefaultContent(AssetServiceRepository.ServiceType.TAG));
    }

    private /* synthetic */ AssetServiceRepository.ServiceBuilder lambda$assetServiceRepository$2(AssetServiceRepository.ServiceIdGen idGen, Service.ServiceInit init, ScriptRepository scriptRepository, ObjectMapper objectMapper, AssetServiceRepository.ServiceStore store) {
        return new FlowTaskServiceBuilder(idGen, store, init, scriptRepository, objectMapper, this.getDefaultContent(AssetServiceRepository.ServiceType.FLOW_TASK));
    }

    private /* synthetic */ AssetServiceRepository.ServiceBuilder lambda$assetServiceRepository$1(AssetServiceRepository.ServiceIdGen idGen, FlowRepository flowRepository, ClockRepository clockRepository, AssetServiceRepository.ServiceStore store) {
        return new FlowServiceBuilder(idGen, store, flowRepository, flowRepository, clockRepository, this.getDefaultContent(AssetServiceRepository.ServiceType.FLOW));
    }

    private /* synthetic */ AssetServiceRepository.ServiceBuilder lambda$assetServiceRepository$0(AssetServiceRepository.ServiceIdGen idGen, DecisionTableRepository decisionTableRepository, ClockRepository clockRepository, AssetServiceRepository.ServiceStore store) {
        return new DtServiceBuilder(idGen, decisionTableRepository, clockRepository, this.getDefaultContent(AssetServiceRepository.ServiceType.DT));
    }

    public static class Loader {
        private final AssetLocation location;
        private final AssetServiceRepository assetRepository;

        public Loader(AssetLocation location, AssetServiceRepository assetRepository) {
            this.location = location;
            this.assetRepository = assetRepository;
        }

        @EventListener(value={ContextRefreshedEvent.class})
        public void load() {
            ListAssetLoader result = new ListAssetLoader(this.assetRepository, this.location);
            result.load();
        }
    }
}

