/*
 * Decompiled with CFR 0.152.
 */
package io.resys.wrench.assets.git;

import io.resys.wrench.assets.bundle.api.repositories.AssetServiceRepository;
import io.resys.wrench.assets.bundle.spi.store.AssetLocation;
import io.resys.wrench.assets.bundle.spi.store.GitAssetStore;
import io.resys.wrench.assets.bundle.spi.store.git.AssetAuthorProvider;
import io.resys.wrench.assets.bundle.spi.store.git.GitRepository;
import io.resys.wrench.assets.bundle.spi.store.git.SshGitRepository;
import io.resys.wrench.assets.context.config.GitConfigBean;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(name={"wrench.assets.git.enabled"}, havingValue="true")
public class AssetGitConfiguration {
    @Bean
    public GitRepository gitRepository(GitConfigBean gitConfigBean, Optional<AssetAuthorProvider> authorProvider) throws InvalidRemoteException, IOException, GitAPIException {
        if (authorProvider.isEmpty()) {
            authorProvider = gitConfigBean.getEmail() != null && gitConfigBean.getEmail().contains("@") ? Optional.of(() -> new AssetAuthorProvider.Author(gitConfigBean.getEmail().split("@")[0], gitConfigBean.getEmail())) : Optional.of(() -> new AssetAuthorProvider.Author("assetManager", "assetManager@resys.io"));
        }
        return new SshGitRepository(gitConfigBean.toConfig(), authorProvider.get());
    }

    @Bean
    public AssetLocation gitAsssetLocation(GitRepository gitRepository) {
        return new AssetLocation(gitRepository.getWorkingDir(), "/assets/", true);
    }

    @Bean
    public AssetServiceRepository.ServiceStore serviceStore(GitRepository gitRepository, AssetLocation location) {
        return new GitAssetStore(gitRepository, location);
    }
}

