/*
 * Decompiled with CFR 0.152.
 */
package io.resys.wrench.assets.controllers;

import com.fasterxml.jackson.databind.JsonNode;
import io.resys.wrench.assets.bundle.api.repositories.AssetIdeServices;
import io.resys.wrench.assets.bundle.api.repositories.AssetServiceRepository;
import io.resys.wrench.assets.bundle.api.repositories.ImmutableAssetResource;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${wrench.assets.ide.services:/assets}"})
public class IdeServicesController {
    private final AssetIdeServices assetIdeServices;

    public IdeServicesController(AssetIdeServices assetIdeServices) {
        this.assetIdeServices = assetIdeServices;
    }

    @GetMapping(value={"/about"}, produces={"application/json"})
    public AssetIdeServices.AssetSummary summaries() {
        return this.assetIdeServices.summary();
    }

    @GetMapping(value={"/dataModels"}, produces={"application/json"})
    public Map<AssetServiceRepository.ServiceType, List<AssetServiceRepository.ServiceDataModel>> dataModels() {
        return this.assetIdeServices.models();
    }

    @PostMapping(path={"/commands"}, produces={"application/json"}, consumes={"application/json"})
    public JsonNode commands(@RequestBody AssetIdeServices.AssetCommand command) {
        return this.assetIdeServices.commands(command);
    }

    @PostMapping(path={"/debugs"}, produces={"application/json"}, consumes={"application/json"})
    public String debug(@RequestBody AssetIdeServices.AssetDebug debug) {
        return this.assetIdeServices.debug(debug);
    }

    @PostMapping(path={"/resources"}, produces={"application/json"}, consumes={"application/json"})
    public AssetIdeServices.AssetResource create(@RequestBody AssetIdeServices.CreateAssetResource entity) {
        return this.assetIdeServices.persist((AssetIdeServices.AssetResource)ImmutableAssetResource.builder().type(entity.getType()).name(entity.getName()).content("").build());
    }

    @PutMapping(path={"/resources/{id}"}, produces={"application/json"}, consumes={"application/json"})
    public AssetIdeServices.AssetResource update(@PathVariable String id, @RequestBody AssetIdeServices.UpdateAssetResource entity) {
        return this.assetIdeServices.persist((AssetIdeServices.AssetResource)ImmutableAssetResource.builder().id(id).type(entity.getType()).content(entity.getContent()).build());
    }

    @DeleteMapping(path={"/resources/{id}"}, produces={"application/json"})
    public ResponseEntity<AssetIdeServices.AssetResource> delete(@PathVariable String id) {
        Collection resources = this.assetIdeServices.query().id(id).build();
        if (resources.isEmpty()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        AssetIdeServices.AssetResource resource = this.assetIdeServices.remove((AssetIdeServices.AssetResource)resources.iterator().next());
        return new ResponseEntity((Object)resource, HttpStatus.OK);
    }

    @PostMapping(path={"/copyas"}, produces={"application/json"}, consumes={"application/json"})
    public AssetIdeServices.AssetResource copyAs(@RequestBody AssetIdeServices.AssetCopyAs entity) {
        return this.assetIdeServices.copyAs(entity);
    }

    @GetMapping(path={"/resources/{id}"}, produces={"application/json"})
    public ResponseEntity<AssetIdeServices.AssetResource> get(@PathVariable String id) {
        Collection resources = this.assetIdeServices.query().id(id).build();
        if (resources.isEmpty()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)((AssetIdeServices.AssetResource)resources.iterator().next()), HttpStatus.OK);
    }

    @GetMapping(path={"/resources"}, produces={"application/json"})
    public Collection<AssetIdeServices.AssetResource> find(@RequestParam(value="id") String id, @RequestParam(value="name") String name, @RequestParam(value="rev") String rev, @RequestParam(value="type") AssetServiceRepository.ServiceType type) {
        return this.assetIdeServices.query().id(id).name(name).rev(rev).type(type).build();
    }
}

