/*
 * Decompiled with CFR 0.152.
 */
package io.resys.wrench.assets.context.config;

import io.resys.wrench.assets.bundle.spi.store.git.GitConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="wrench.assets.git")
public class GitConfigBean {
    private String repositoryUrl;
    private String branchSpecifier;
    private String repositoryPath;
    @Value(value="${enabled:false}")
    private boolean enabled;
    @Value(value="${privateKey:classpath:ssh/id_rsa}")
    private String privateKey;
    @Value(value="${email:asset.manager@resys.io}")
    private String email;
    @Value(value="${message:application commit}")
    private String message;
    @Value(value="${path:src/main/resources}")
    private String path;

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public GitConfigBean setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        return this;
    }

    public String getBranchSpecifier() {
        return this.branchSpecifier;
    }

    public GitConfigBean setBranchSpecifier(String branchSpecifier) {
        this.branchSpecifier = branchSpecifier;
        return this;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public GitConfigBean setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public GitConfigBean setPath(String path) {
        this.path = path;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public GitConfig toConfig() {
        return new GitConfig().setBranchSpecifier(this.branchSpecifier).setPath(this.path).setPrivateKey(this.privateKey).setRepositoryUrl(this.repositoryUrl).setEmail(this.email).setMessage(this.message).setRepositoryPath(this.repositoryPath);
    }
}

