/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.projects.quarkus.deployment;

import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.util.FileUtil;
import io.resys.hdes.projects.spi.support.RepoAssert;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public class IndexFactory {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String frontendPath;
        private String backendPath;
        private String projectsPath;
        private String usersPath;
        private String groupsPath;
        private String indexFileContent;

        public Builder frontend(String frontendPath) {
            this.frontendPath = frontendPath;
            return this;
        }

        public Builder backend(String backendPath) {
            this.backendPath = backendPath;
            return this;
        }

        public Builder backendProjects(String projectsPath) {
            this.projectsPath = projectsPath;
            return this;
        }

        public Builder backendUsers(String usersPath) {
            this.usersPath = usersPath;
            return this;
        }

        public Builder backendGroups(String groupsPath) {
            this.groupsPath = groupsPath;
            return this;
        }

        public Builder index(Path path) {
            File file = path.toFile();
            try (FileInputStream stream = new FileInputStream(file);){
                byte[] bytes = FileUtil.readFileContents((InputStream)stream);
                this.indexFileContent = new String(bytes, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new ConfigurationError("Failed to create frontend index.html, " + "msg = " + e.getMessage() + System.lineSeparator() + "," + "path = " + path + "!");
            }
            return this;
        }

        public Builder index(byte[] indexFileContent) {
            this.indexFileContent = new String(indexFileContent, StandardCharsets.UTF_8);
            return this;
        }

        public byte[] build() {
            RepoAssert.notEmpty((String)this.frontendPath, () -> "define frontendPath!");
            RepoAssert.notEmpty((String)this.backendPath, () -> "define backendPath!");
            RepoAssert.notEmpty((String)this.projectsPath, () -> "define projectsPath!");
            RepoAssert.notEmpty((String)this.usersPath, () -> "define usersPath!");
            RepoAssert.notEmpty((String)this.groupsPath, () -> "define groupsPath!");
            RepoAssert.notEmpty((String)this.indexFileContent, () -> "define indexFileContent!");
            String newPath = this.frontendPath.startsWith("/") ? this.frontendPath.substring(1) : this.frontendPath;
            StringBuilder newScript = new StringBuilder().append(newPath).append("/static/js/");
            StringBuilder newHref = new StringBuilder().append("href=\"").append("/").append(newPath).append("/");
            StringBuilder newConfig = new StringBuilder().append("const hdesconfig={").append("ctx: \"").append(this.backendPath).append("\", ").append("projects: \"").append(this.projectsPath).append("\", ").append("groups: \"").append(this.groupsPath).append("\",").append("users: \"").append(this.usersPath).append("\"").append("}");
            String original = this.indexFileContent;
            return (this.indexFileContent.replaceAll("href=\"/", newHref.toString()).replaceAll("static/js/", newScript.toString()).replaceFirst("const hdesconfig=\\{\\}", newConfig.toString()) + "<!--" + original + "-->").getBytes(StandardCharsets.UTF_8);
        }
    }
}

