/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.projects.quarkus.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.WebJarUtil;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.resys.hdes.pm.quarkus.runtime.HdesProjectsContextProducer;
import io.resys.hdes.pm.quarkus.runtime.HdesProjectsRecorder;
import io.resys.hdes.projects.quarkus.deployment.HdesProjectsConfig;
import io.resys.hdes.projects.quarkus.deployment.HdesUIBuildItem;
import io.resys.hdes.projects.quarkus.deployment.IndexFactory;
import io.vertx.core.Handler;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdesProjectsProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HdesProjectsProcessor.class);
    private static final String WEBJAR_GROUP_ID = "io.resys.hdes";
    private static final String WEBJAR_ARTIFACT_ID = "hdes-pm-frontend";
    private static final String WEBJAR_PREFIX = "META-INF/resources/webjars/hdes-pm-frontend/";
    private static final String FINAL_DESTINATION = "META-INF/hdes-pm-files";
    public static final String FEATURE_BUILD_ITEM = "hdes-projects";
    @Inject
    private LaunchModeBuildItem launch;
    HdesProjectsConfig hdesProjectsConfig;

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE_BUILD_ITEM);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void backendBeans(HdesProjectsRecorder recorder, BuildProducer<AdditionalBeanBuildItem> buildItems, BuildProducer<BeanContainerListenerBuildItem> beans) {
        if ("/".equals(this.hdesProjectsConfig.connectionUrl)) {
            throw new ConfigurationError("quarkus.hdes-projects.connectionUrl was set to \"/\", this is not allowed as it blocks the application from serving anything else.");
        }
        buildItems.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(HdesProjectsContextProducer.class).build());
        beans.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.listener(this.hdesProjectsConfig.connectionUrl, this.hdesProjectsConfig.initUserName, this.hdesProjectsConfig.dbName)));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void backendHandlers(HdesProjectsRecorder recorder, BodyHandlerBuildItem body, BuildProducer<RouteBuildItem> routes) {
        if ("/".equals(this.hdesProjectsConfig.backendPath)) {
            throw new ConfigurationError("quarkus.hdes-projects.backendPath was set to \"/\", this is not allowed as it blocks the application from serving anything else.");
        }
        routes.produce((BuildItem)new RouteBuildItem.Builder().routeFunction(recorder.routeFunction(this.hdesProjectsConfig.getTokens(), body.getHandler())).handler(recorder.tokenHandler()).blockingRoute().build());
        routes.produce((BuildItem)new RouteBuildItem.Builder().routeFunction(recorder.routeFunction(this.hdesProjectsConfig.getUsers(), body.getHandler())).handler(recorder.userHandler()).blockingRoute().build());
        routes.produce((BuildItem)new RouteBuildItem.Builder().routeFunction(recorder.routeFunction(this.hdesProjectsConfig.getGroups(), body.getHandler())).handler(recorder.groupHandler()).blockingRoute().build());
        routes.produce((BuildItem)new RouteBuildItem.Builder().routeFunction(recorder.routeFunction(this.hdesProjectsConfig.getProjects(), body.getHandler())).handler(recorder.projectHandler()).blockingRoute().build());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void frontendHandler(HdesProjectsRecorder recorder, BuildProducer<RouteBuildItem> routes, HdesUIBuildItem buildItem, HdesProjectsConfig uiConfig, BodyHandlerBuildItem body) throws Exception {
        Handler handler = recorder.uiHandler(buildItem.getUiFinalDestination(), buildItem.getUiPath());
        routes.produce((BuildItem)new RouteBuildItem.Builder().routeFunction(recorder.routeFunction(uiConfig.frontendPath, body.getHandler())).handler(handler).nonApplicationRoute().build());
        routes.produce((BuildItem)new RouteBuildItem.Builder().routeFunction(recorder.routeFunction(uiConfig.frontendPath + "/*", body.getHandler())).handler(handler).nonApplicationRoute().build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void frontendBeans(HdesProjectsRecorder recorder, BuildProducer<HdesUIBuildItem> buildProducer, BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<NativeImageResourceBuildItem> nativeImage, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, LiveReloadBuildItem liveReloadBuildItem, HttpRootPathBuildItem httpRootPathBuildItem, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints) throws Exception {
        if ("/".equals(this.hdesProjectsConfig.frontendPath)) {
            throw new ConfigurationError("quarkus.hdes-projects.frontendPath was set to \"/\", this is not allowed as it blocks the application from serving anything else.");
        }
        AppArtifact artifact = WebJarUtil.getAppArtifact((CurateOutcomeBuildItem)curateOutcomeBuildItem, (String)WEBJAR_GROUP_ID, (String)WEBJAR_ARTIFACT_ID);
        String frontendPath = httpRootPathBuildItem.adjustPath(nonApplicationRootPathBuildItem.adjustPath(this.hdesProjectsConfig.frontendPath));
        if (this.launch.getLaunchMode().isDevOrTest()) {
            Path tempPath = WebJarUtil.copyResourcesForDevOrTest((CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)this.launch, (AppArtifact)artifact, (String)("META-INF/resources/webjars/hdes-pm-frontend//" + artifact.getVersion()));
            Path index = tempPath.resolve("index.html");
            WebJarUtil.updateFile((Path)index, (byte[])IndexFactory.builder().frontend(frontendPath).backend(httpRootPathBuildItem.adjustPath(this.hdesProjectsConfig.backendPath)).backendProjects(httpRootPathBuildItem.adjustPath(this.hdesProjectsConfig.getProjects())).backendGroups(httpRootPathBuildItem.adjustPath(this.hdesProjectsConfig.getGroups())).backendUsers(httpRootPathBuildItem.adjustPath(this.hdesProjectsConfig.getUsers())).index(index).build());
            buildProducer.produce((BuildItem)new HdesUIBuildItem(tempPath.toAbsolutePath().toString(), nonApplicationRootPathBuildItem.adjustPath(this.hdesProjectsConfig.frontendPath)));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(nonApplicationRootPathBuildItem.adjustPath(this.hdesProjectsConfig.frontendPath + "/"), "HDES Projects UI"));
            if (liveReloadBuildItem.isLiveReload() && !liveReloadBuildItem.getChangedResources().isEmpty()) {
                WebJarUtil.hotReloadBrandingChanges((CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)this.launch, (AppArtifact)artifact, (Set)liveReloadBuildItem.getChangedResources());
            }
        } else {
            Map files = WebJarUtil.copyResourcesForProduction((CurateOutcomeBuildItem)curateOutcomeBuildItem, (AppArtifact)artifact, (String)WEBJAR_PREFIX);
            for (Map.Entry file : files.entrySet()) {
                Object fileName = (String)file.getKey();
                byte[] content = ((String)fileName).endsWith("index.html") ? IndexFactory.builder().frontend(frontendPath).backend(httpRootPathBuildItem.adjustPath(this.hdesProjectsConfig.backendPath)).backendProjects(httpRootPathBuildItem.adjustPath(this.hdesProjectsConfig.getProjects())).backendGroups(httpRootPathBuildItem.adjustPath(this.hdesProjectsConfig.getGroups())).backendUsers(httpRootPathBuildItem.adjustPath(this.hdesProjectsConfig.getUsers())).index((byte[])file.getValue()).build() : (byte[])file.getValue();
                fileName = "META-INF/hdes-pm-files/" + (String)fileName;
                generatedResources.produce((BuildItem)new GeneratedResourceBuildItem((String)fileName, content));
                nativeImage.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fileName}));
            }
            buildProducer.produce((BuildItem)new HdesUIBuildItem(FINAL_DESTINATION, frontendPath));
        }
    }
}

