/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.object.repo.mongodb.writers;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import io.resys.hdes.object.repo.api.ImmutableObjects;
import io.resys.hdes.object.repo.api.ObjectRepository;
import io.resys.hdes.object.repo.api.exceptions.RepoException;
import io.resys.hdes.object.repo.mongodb.MongoCommand;
import io.resys.hdes.object.repo.spi.mapper.ObjectRepositoryMapper;
import java.util.HashMap;
import java.util.List;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbWriter
implements ObjectRepositoryMapper.Writer<MongoClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbWriter.class);
    private final MongoCommand<ObjectRepository.Objects> command;
    private final MongoCommand.MongoDbConfig mongoDbConfig;
    private final ObjectRepository.Objects src;
    private final StringBuilder log = new StringBuilder("Writing transaction: ").append(System.lineSeparator());

    public MongoDbWriter(ObjectRepository.Objects src, MongoCommand<ObjectRepository.Objects> command, MongoCommand.MongoDbConfig mongoDbConfig) {
        this.command = command;
        this.mongoDbConfig = mongoDbConfig;
        this.src = src;
    }

    public ObjectRepository.Objects build(List<Object> objects) {
        return this.command.accept(client -> {
            HashMap<String, ObjectRepository.Ref> refs = new HashMap<String, ObjectRepository.Ref>(this.src.getRefs());
            HashMap<String, ObjectRepository.Tag> tags = new HashMap<String, ObjectRepository.Tag>(this.src.getTags());
            HashMap<String, Object> values = new HashMap<String, Object>(this.src.getValues());
            for (Object value : objects) {
                if (value instanceof ObjectRepository.Blob) {
                    ObjectRepository.Blob blob = (ObjectRepository.Blob)value;
                    values.put(blob.getId(), this.visitBlob((MongoClient)client, blob));
                    continue;
                }
                if (value instanceof ObjectRepository.Commit) {
                    ObjectRepository.Commit commit = (ObjectRepository.Commit)value;
                    values.put(commit.getId(), this.visitCommit((MongoClient)client, commit));
                    continue;
                }
                if (value instanceof ObjectRepository.Tree) {
                    ObjectRepository.Tree tree = (ObjectRepository.Tree)value;
                    values.put(tree.getId(), this.visitTree((MongoClient)client, tree));
                    continue;
                }
                if (value instanceof ObjectRepository.Ref) {
                    ObjectRepository.Ref ref = (ObjectRepository.Ref)value;
                    refs.put(ref.getName(), this.visitRef((MongoClient)client, ref));
                    continue;
                }
                if (value instanceof ObjectRepository.Tag) {
                    ObjectRepository.Tag tag = (ObjectRepository.Tag)value;
                    tags.put(tag.getName(), this.visitTag((MongoClient)client, tag));
                    continue;
                }
                throw new RepoException("Unknown object: " + value);
            }
            LOGGER.debug(this.log.toString());
            return ImmutableObjects.builder().values(values).refs(refs).tags(tags).build();
        });
    }

    public ObjectRepository.Ref visitRef(MongoClient client, ObjectRepository.Ref ref) {
        Bson filter;
        MongoCollection collection = client.getDatabase(this.mongoDbConfig.getDb()).getCollection(this.mongoDbConfig.getRefs(), ObjectRepository.Ref.class);
        ObjectRepository.Ref value = (ObjectRepository.Ref)collection.find(filter = Filters.eq((String)"_id", (Object)ref.getName())).first();
        if (value != null) {
            collection.updateOne(filter, Updates.set((String)"commit", (Object)ref.getCommit()));
            this.log.append("  - ").append(ref).append(System.lineSeparator());
        } else {
            collection.insertOne((Object)ref);
            this.log.append("  - ").append(ref).append(System.lineSeparator());
        }
        return ref;
    }

    public ObjectRepository.Tag visitTag(MongoClient client, ObjectRepository.Tag tag) {
        Bson filter;
        MongoCollection collection = client.getDatabase(this.mongoDbConfig.getDb()).getCollection(this.mongoDbConfig.getTags(), ObjectRepository.Tag.class);
        ObjectRepository.Tag value = (ObjectRepository.Tag)collection.find(filter = Filters.eq((String)"_id", (Object)tag.getName())).first();
        if (value != null) {
            collection.updateOne(filter, Updates.set((String)"commit", (Object)tag.getCommit()));
            this.log.append("  - update ").append(tag).append(System.lineSeparator());
        } else {
            collection.insertOne((Object)value);
            this.log.append("  - ").append(tag).append(System.lineSeparator());
        }
        return tag;
    }

    public ObjectRepository.Commit visitCommit(MongoClient client, ObjectRepository.Commit commit) {
        Bson filter;
        MongoCollection collection = client.getDatabase(this.mongoDbConfig.getDb()).getCollection(this.mongoDbConfig.getObjects(), ObjectRepository.Commit.class);
        ObjectRepository.Commit value = (ObjectRepository.Commit)collection.find(filter = Filters.eq((String)"_id", (Object)commit.getId())).first();
        if (value != null) {
            this.log.append("  - commit reuse: ").append(commit.getId()).append(System.lineSeparator());
        } else {
            collection.insertOne((Object)commit);
            this.log.append("  - commit: ").append(commit.getId()).append(System.lineSeparator());
        }
        return commit;
    }

    public ObjectRepository.Blob visitBlob(MongoClient client, ObjectRepository.Blob blob) {
        Bson filter;
        MongoCollection collection = client.getDatabase(this.mongoDbConfig.getDb()).getCollection(this.mongoDbConfig.getObjects(), ObjectRepository.Blob.class);
        ObjectRepository.Blob value = (ObjectRepository.Blob)collection.find(filter = Filters.eq((String)"_id", (Object)blob.getId())).first();
        if (value != null) {
            this.log.append("  - blob reuse: ").append(value.getId()).append(System.lineSeparator());
        } else {
            collection.insertOne((Object)blob);
            this.log.append("  - blob: ").append(blob.getId()).append(System.lineSeparator());
        }
        return blob;
    }

    public ObjectRepository.Tree visitTree(MongoClient client, ObjectRepository.Tree tree) {
        Bson filter;
        MongoCollection collection = client.getDatabase(this.mongoDbConfig.getDb()).getCollection(this.mongoDbConfig.getObjects(), ObjectRepository.Tree.class);
        ObjectRepository.Tree value = (ObjectRepository.Tree)collection.find(filter = Filters.eq((String)"_id", (Object)tree.getId())).first();
        if (value != null) {
            this.log.append("  - tree reuse: ").append(value.getId()).append(System.lineSeparator());
        } else {
            collection.insertOne((Object)tree);
            this.log.append("  - tree: ").append(tree.getId()).append(System.lineSeparator());
        }
        return tree;
    }

    public ObjectRepository.Head visitHead(MongoClient to, ObjectRepository.Head head) {
        return null;
    }
}

