/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.object.repo.mongodb.writers;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import io.resys.hdes.object.repo.api.ImmutableObjects;
import io.resys.hdes.object.repo.api.ObjectRepository;
import io.resys.hdes.object.repo.mongodb.MongoCommand;
import io.resys.hdes.object.repo.spi.mapper.ObjectRepositoryMapper;
import java.util.HashMap;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbDelete
implements ObjectRepositoryMapper.Delete<MongoClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbDelete.class);
    private final MongoCommand<ObjectRepository.Objects> command;
    private final MongoCommand.MongoDbConfig mongoDbConfig;
    private final ObjectRepository.Objects src;
    private final StringBuilder log = new StringBuilder("Writing transaction: ").append(System.lineSeparator());

    public MongoDbDelete(ObjectRepository.Objects src, MongoCommand<ObjectRepository.Objects> command, MongoCommand.MongoDbConfig mongoDbConfig) {
        this.command = command;
        this.mongoDbConfig = mongoDbConfig;
        this.src = src;
    }

    public ObjectRepository.Objects build(ObjectRepository.RefStatus refStatus) {
        return this.command.accept(client -> {
            HashMap refs = new HashMap(this.src.getRefs());
            HashMap tags = new HashMap(this.src.getTags());
            HashMap values = new HashMap(this.src.getValues());
            ObjectRepository.Ref ref = (ObjectRepository.Ref)refs.get(refStatus.getName());
            this.visitRef((MongoClient)client, ref);
            refs.remove(refStatus.getName());
            LOGGER.debug(this.log.toString());
            return ImmutableObjects.builder().values(values).refs(refs).tags(tags).build();
        });
    }

    public ObjectRepository.Ref visitRef(MongoClient client, ObjectRepository.Ref ref) {
        this.log.append("  - deleting: ").append(ref.getName()).append(" - ").append(ref);
        MongoCollection collection = client.getDatabase(this.mongoDbConfig.getDb()).getCollection(this.mongoDbConfig.getRefs(), ObjectRepository.Ref.class);
        Bson filter = Filters.eq((String)"_id", (Object)ref.getName());
        collection.deleteOne(filter);
        return ref;
    }
}

