/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.object.repo.mongodb.codecs;

import io.resys.hdes.object.repo.api.ImmutableTreeEntry;
import io.resys.hdes.object.repo.api.ObjectRepository;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class TreeEntryCodec
implements Codec<ObjectRepository.TreeEntry> {
    public static final String NAME = "name";
    private static final String BLOB = "blob";

    public void encode(BsonWriter writer, ObjectRepository.TreeEntry command, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString(NAME, command.getName());
        writer.writeString(BLOB, command.getBlob());
        writer.writeEndDocument();
    }

    public ObjectRepository.TreeEntry decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        ImmutableTreeEntry result = ImmutableTreeEntry.builder().name(reader.readString(NAME)).blob(reader.readString(BLOB)).build();
        reader.readEndDocument();
        return result;
    }

    public Class<ObjectRepository.TreeEntry> getEncoderClass() {
        return ObjectRepository.TreeEntry.class;
    }
}

