/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.object.repo.mongodb.codecs;

import io.resys.hdes.object.repo.api.ImmutableTree;
import io.resys.hdes.object.repo.api.ObjectRepository;
import io.resys.hdes.object.repo.mongodb.codecs.TreeEntryCodec;
import java.util.HashMap;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class TreeCodec
implements Codec<ObjectRepository.Tree> {
    public static final String ID = "_id";
    public static final String VALUES = "values";
    private final TreeEntryCodec entryCode;

    public TreeCodec(TreeEntryCodec entryCode) {
        this.entryCode = entryCode;
    }

    public void encode(BsonWriter writer, ObjectRepository.Tree value, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString(ID, value.getId());
        writer.writeStartArray(VALUES);
        for (ObjectRepository.TreeEntry command : value.getValues().values()) {
            this.entryCode.encode(writer, command, encoderContext);
        }
        writer.writeEndArray();
        writer.writeEndDocument();
    }

    public ObjectRepository.Tree decode(BsonReader reader, DecoderContext decoderContext) {
        ImmutableTree.Builder changes = ImmutableTree.builder();
        reader.readStartDocument();
        changes.id(reader.readString(ID));
        reader.readName(VALUES);
        reader.readStartArray();
        HashMap<String, ObjectRepository.TreeEntry> commands = new HashMap<String, ObjectRepository.TreeEntry>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            ObjectRepository.TreeEntry entry = this.entryCode.decode(reader, decoderContext);
            commands.put(entry.getName(), entry);
        }
        reader.readEndArray();
        reader.readEndDocument();
        return changes.values(commands).build();
    }

    public Class<ObjectRepository.Tree> getEncoderClass() {
        return ObjectRepository.Tree.class;
    }
}

