/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.object.repo.mongodb.codecs;

import io.resys.hdes.object.repo.api.ImmutableTag;
import io.resys.hdes.object.repo.api.ObjectRepository;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class TagCodec
implements Codec<ObjectRepository.Tag> {
    public static final String ID = "_id";
    public static final String COMMIT = "commit";

    public void encode(BsonWriter writer, ObjectRepository.Tag command, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString(ID, command.getName());
        writer.writeString(COMMIT, command.getCommit());
        writer.writeEndDocument();
    }

    public ObjectRepository.Tag decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        ImmutableTag result = ImmutableTag.builder().name(reader.readString(ID)).commit(reader.readString(COMMIT)).build();
        reader.readEndDocument();
        return result;
    }

    public Class<ObjectRepository.Tag> getEncoderClass() {
        return ObjectRepository.Tag.class;
    }
}

