/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.object.repo.mongodb.codecs;

import io.resys.hdes.object.repo.api.ObjectRepository;
import io.resys.hdes.object.repo.mongodb.codecs.BlobCodec;
import io.resys.hdes.object.repo.mongodb.codecs.CommitCodec;
import io.resys.hdes.object.repo.mongodb.codecs.RefCodec;
import io.resys.hdes.object.repo.mongodb.codecs.TagCodec;
import io.resys.hdes.object.repo.mongodb.codecs.TreeCodec;
import io.resys.hdes.object.repo.mongodb.codecs.TreeEntryCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;

public class ObjectRepositoryCodeProvider
implements CodecProvider {
    private final CommitCodec commit = new CommitCodec();
    private final BlobCodec blob = new BlobCodec();
    private final TreeEntryCodec treeEntry = new TreeEntryCodec();
    private final TreeCodec tree = new TreeCodec(this.treeEntry);
    private final TagCodec tag = new TagCodec();
    private final RefCodec ref = new RefCodec();

    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (ObjectRepository.Commit.class.isAssignableFrom(clazz)) {
            return this.commit;
        }
        if (ObjectRepository.Blob.class.isAssignableFrom(clazz)) {
            return this.blob;
        }
        if (ObjectRepository.Tree.class.isAssignableFrom(clazz)) {
            return this.tree;
        }
        if (ObjectRepository.TreeEntry.class.isAssignableFrom(clazz)) {
            return this.treeEntry;
        }
        if (ObjectRepository.Tag.class.isAssignableFrom(clazz)) {
            return this.tag;
        }
        if (ObjectRepository.Ref.class.isAssignableFrom(clazz)) {
            return this.ref;
        }
        return null;
    }
}

