/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.object.repo.mongodb.codecs;

import io.resys.hdes.object.repo.api.ImmutableBlob;
import io.resys.hdes.object.repo.api.ObjectRepository;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class BlobCodec
implements Codec<ObjectRepository.Blob> {
    public static final String ID = "_id";
    private static final String VALUE = "value";

    public void encode(BsonWriter writer, ObjectRepository.Blob command, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString(ID, command.getId());
        writer.writeString(VALUE, command.getValue());
        writer.writeEndDocument();
    }

    public ObjectRepository.Blob decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartDocument();
        ImmutableBlob result = ImmutableBlob.builder().id(reader.readString(ID)).value(reader.readString(VALUE)).build();
        reader.readEndDocument();
        return result;
    }

    public Class<ObjectRepository.Blob> getEncoderClass() {
        return ObjectRepository.Blob.class;
    }
}

