/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.object.repo.mongodb;

import com.mongodb.client.MongoClient;
import io.resys.hdes.object.repo.api.ImmutableObjects;
import io.resys.hdes.object.repo.api.ObjectRepository;
import io.resys.hdes.object.repo.mongodb.ImmutableMongoDbConfig;
import io.resys.hdes.object.repo.mongodb.MongoCommand;
import io.resys.hdes.object.repo.mongodb.writers.MongoDbDelete;
import io.resys.hdes.object.repo.mongodb.writers.MongoDbWriter;
import io.resys.hdes.object.repo.spi.RepoAssert;
import io.resys.hdes.object.repo.spi.commands.GenericCommitBuilder;
import io.resys.hdes.object.repo.spi.commands.GenericMergeBuilder;
import io.resys.hdes.object.repo.spi.commands.GenericSnapshotBuilder;
import io.resys.hdes.object.repo.spi.commands.GenericStatusBuilder;
import io.resys.hdes.object.repo.spi.commands.GenericTagBuilder;
import io.resys.hdes.object.repo.spi.file.FileObjectsSerializerAndDeserializer;
import io.resys.hdes.object.repo.spi.mapper.GenericObjectRepositoryMapper;
import io.resys.hdes.object.repo.spi.mapper.ObjectRepositoryMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class MongoDbObjectRepository
implements ObjectRepository.Commands,
ObjectRepository {
    private final ObjectRepositoryMapper<MongoClient> mapper;
    private ObjectRepository.Objects objects;

    public MongoDbObjectRepository(ObjectRepository.Objects objects, ObjectRepositoryMapper<MongoClient> mapper) {
        this.objects = objects;
        this.mapper = mapper;
    }

    public ObjectRepository.CommitBuilder commit() {
        return new GenericCommitBuilder(this.objects, this.mapper){

            protected ObjectRepository.Objects save(List<Object> input) {
                return MongoDbObjectRepository.this.setObjects(MongoDbObjectRepository.this.mapper.writer(MongoDbObjectRepository.this.objects).build(input));
            }
        };
    }

    public ObjectRepository.TagBuilder tag() {
        return new GenericTagBuilder(this.objects){

            public ObjectRepository.Tag build() {
                ObjectRepository.Tag result = super.build();
                MongoDbObjectRepository.this.setObjects(MongoDbObjectRepository.this.mapper.writer(MongoDbObjectRepository.this.objects).build(Arrays.asList(result)));
                return result;
            }
        };
    }

    public ObjectRepository.SnapshotBuilder snapshot() {
        return new GenericSnapshotBuilder(this.objects);
    }

    public ObjectRepository.StatusBuilder status() {
        return new GenericStatusBuilder(this.objects);
    }

    public ObjectRepository.MergeBuilder merge() {
        return new GenericMergeBuilder(this.objects, () -> this.commit()){

            protected ObjectRepository.Objects delete(ObjectRepository.RefStatus ref) {
                return MongoDbObjectRepository.this.setObjects(MongoDbObjectRepository.this.mapper.delete(MongoDbObjectRepository.this.objects).build(ref));
            }
        };
    }

    public ObjectRepository.HistoryBuilder history() {
        return null;
    }

    public ObjectRepository.Objects objects() {
        return this.objects;
    }

    public ObjectRepository.Commands commands() {
        return this;
    }

    private ObjectRepository.Objects setObjects(ObjectRepository.Objects objects) {
        this.objects = objects;
        return objects;
    }

    public static Config config() {
        return new Config();
    }

    public ObjectRepository.CheckoutBuilder checkout() {
        return null;
    }

    public ObjectRepository.PullCommand pull() {
        return null;
    }

    public static class Config {
        private MongoCommand<ObjectRepository.Objects> command;
        private MongoCommand.MongoDbConfig config;

        public Config command(MongoCommand<ObjectRepository.Objects> command) {
            this.command = command;
            return this;
        }

        public Config config(MongoCommand.MongoDbConfig config) {
            this.config = config;
            return this;
        }

        public ObjectRepository build() {
            RepoAssert.notNull(this.command, () -> "command must be defined!");
            if (this.config == null) {
                this.config = ImmutableMongoDbConfig.builder().db("repo").refs("refs").tags("tags").objects("objects").build();
            }
            FileObjectsSerializerAndDeserializer serializer = FileObjectsSerializerAndDeserializer.INSTANCE;
            HashMap refs = new HashMap();
            HashMap tags = new HashMap();
            HashMap values = new HashMap();
            ImmutableObjects objects = ImmutableObjects.builder().values(values).tags(tags).refs(refs).build();
            return new MongoDbObjectRepository((ObjectRepository.Objects)objects, (ObjectRepositoryMapper<MongoClient>)new GenericObjectRepositoryMapper((ObjectRepositoryMapper.Serializer)serializer, (ObjectRepositoryMapper.Deserializer)serializer, v -> new MongoDbWriter((ObjectRepository.Objects)v, this.command, this.config), v -> new MongoDbDelete((ObjectRepository.Objects)v, this.command, this.config)));
        }
    }
}

