/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.object.repo.mongodb;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.object.repo.mongodb.MongoCommand;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MongoCommand.MongoDbConfig", generator="Immutables")
@Immutable
public final class ImmutableMongoDbConfig
implements MongoCommand.MongoDbConfig {
    private final String db;
    private final String refs;
    private final String tags;
    private final String objects;

    private ImmutableMongoDbConfig(String db, String refs, String tags, String objects) {
        this.db = db;
        this.refs = refs;
        this.tags = tags;
        this.objects = objects;
    }

    @Override
    public String getDb() {
        return this.db;
    }

    @Override
    public String getRefs() {
        return this.refs;
    }

    @Override
    public String getTags() {
        return this.tags;
    }

    @Override
    public String getObjects() {
        return this.objects;
    }

    public final ImmutableMongoDbConfig withDb(String value) {
        String newValue = Objects.requireNonNull(value, "db");
        if (this.db.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoDbConfig(newValue, this.refs, this.tags, this.objects);
    }

    public final ImmutableMongoDbConfig withRefs(String value) {
        String newValue = Objects.requireNonNull(value, "refs");
        if (this.refs.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoDbConfig(this.db, newValue, this.tags, this.objects);
    }

    public final ImmutableMongoDbConfig withTags(String value) {
        String newValue = Objects.requireNonNull(value, "tags");
        if (this.tags.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoDbConfig(this.db, this.refs, newValue, this.objects);
    }

    public final ImmutableMongoDbConfig withObjects(String value) {
        String newValue = Objects.requireNonNull(value, "objects");
        if (this.objects.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoDbConfig(this.db, this.refs, this.tags, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoDbConfig && this.equalTo((ImmutableMongoDbConfig)another);
    }

    private boolean equalTo(ImmutableMongoDbConfig another) {
        return this.db.equals(another.db) && this.refs.equals(another.refs) && this.tags.equals(another.tags) && this.objects.equals(another.objects);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.db.hashCode();
        h += (h << 5) + this.refs.hashCode();
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.objects.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MongoDbConfig").omitNullValues().add("db", (Object)this.db).add("refs", (Object)this.refs).add("tags", (Object)this.tags).add("objects", (Object)this.objects).toString();
    }

    public static ImmutableMongoDbConfig copyOf(MongoCommand.MongoDbConfig instance) {
        if (instance instanceof ImmutableMongoDbConfig) {
            return (ImmutableMongoDbConfig)instance;
        }
        return ImmutableMongoDbConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MongoCommand.MongoDbConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DB = 1L;
        private static final long INIT_BIT_REFS = 2L;
        private static final long INIT_BIT_TAGS = 4L;
        private static final long INIT_BIT_OBJECTS = 8L;
        private long initBits = 15L;
        @Nullable
        private String db;
        @Nullable
        private String refs;
        @Nullable
        private String tags;
        @Nullable
        private String objects;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MongoCommand.MongoDbConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.db(instance.getDb());
            this.refs(instance.getRefs());
            this.tags(instance.getTags());
            this.objects(instance.getObjects());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder db(String db) {
            this.db = Objects.requireNonNull(db, "db");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refs(String refs) {
            this.refs = Objects.requireNonNull(refs, "refs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tags(String tags) {
            this.tags = Objects.requireNonNull(tags, "tags");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder objects(String objects) {
            this.objects = Objects.requireNonNull(objects, "objects");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableMongoDbConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMongoDbConfig(this.db, this.refs, this.tags, this.objects);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("db");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("refs");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("tags");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("objects");
            }
            return "Cannot build MongoDbConfig, some of required attributes are not set " + attributes;
        }
    }
}

