package io.resys.hdes.object.repo.mongodb;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongoCommand.MongoDbConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongoDbConfig.builder()}.
 */
@Generated(from = "MongoCommand.MongoDbConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMongoDbConfig
    implements MongoCommand.MongoDbConfig {
  private final String db;
  private final String refs;
  private final String tags;
  private final String objects;

  private ImmutableMongoDbConfig(String db, String refs, String tags, String objects) {
    this.db = db;
    this.refs = refs;
    this.tags = tags;
    this.objects = objects;
  }

  /**
   * @return The value of the {@code db} attribute
   */
  @Override
  public String getDb() {
    return db;
  }

  /**
   * @return The value of the {@code refs} attribute
   */
  @Override
  public String getRefs() {
    return refs;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @Override
  public String getTags() {
    return tags;
  }

  /**
   * @return The value of the {@code objects} attribute
   */
  @Override
  public String getObjects() {
    return objects;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoCommand.MongoDbConfig#getDb() db} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for db
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDbConfig withDb(String value) {
    String newValue = Objects.requireNonNull(value, "db");
    if (this.db.equals(newValue)) return this;
    return new ImmutableMongoDbConfig(newValue, this.refs, this.tags, this.objects);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoCommand.MongoDbConfig#getRefs() refs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for refs
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDbConfig withRefs(String value) {
    String newValue = Objects.requireNonNull(value, "refs");
    if (this.refs.equals(newValue)) return this;
    return new ImmutableMongoDbConfig(this.db, newValue, this.tags, this.objects);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoCommand.MongoDbConfig#getTags() tags} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tags
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDbConfig withTags(String value) {
    String newValue = Objects.requireNonNull(value, "tags");
    if (this.tags.equals(newValue)) return this;
    return new ImmutableMongoDbConfig(this.db, this.refs, newValue, this.objects);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoCommand.MongoDbConfig#getObjects() objects} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for objects
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDbConfig withObjects(String value) {
    String newValue = Objects.requireNonNull(value, "objects");
    if (this.objects.equals(newValue)) return this;
    return new ImmutableMongoDbConfig(this.db, this.refs, this.tags, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongoDbConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongoDbConfig
        && equalTo((ImmutableMongoDbConfig) another);
  }

  private boolean equalTo(ImmutableMongoDbConfig another) {
    return db.equals(another.db)
        && refs.equals(another.refs)
        && tags.equals(another.tags)
        && objects.equals(another.objects);
  }

  /**
   * Computes a hash code from attributes: {@code db}, {@code refs}, {@code tags}, {@code objects}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + db.hashCode();
    h += (h << 5) + refs.hashCode();
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + objects.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MongoDbConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MongoDbConfig")
        .omitNullValues()
        .add("db", db)
        .add("refs", refs)
        .add("tags", tags)
        .add("objects", objects)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link MongoCommand.MongoDbConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongoDbConfig instance
   */
  public static ImmutableMongoDbConfig copyOf(MongoCommand.MongoDbConfig instance) {
    if (instance instanceof ImmutableMongoDbConfig) {
      return (ImmutableMongoDbConfig) instance;
    }
    return ImmutableMongoDbConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongoDbConfig ImmutableMongoDbConfig}.
   * <pre>
   * ImmutableMongoDbConfig.builder()
   *    .db(String) // required {@link MongoCommand.MongoDbConfig#getDb() db}
   *    .refs(String) // required {@link MongoCommand.MongoDbConfig#getRefs() refs}
   *    .tags(String) // required {@link MongoCommand.MongoDbConfig#getTags() tags}
   *    .objects(String) // required {@link MongoCommand.MongoDbConfig#getObjects() objects}
   *    .build();
   * </pre>
   * @return A new ImmutableMongoDbConfig builder
   */
  public static ImmutableMongoDbConfig.Builder builder() {
    return new ImmutableMongoDbConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongoDbConfig ImmutableMongoDbConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongoCommand.MongoDbConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DB = 0x1L;
    private static final long INIT_BIT_REFS = 0x2L;
    private static final long INIT_BIT_TAGS = 0x4L;
    private static final long INIT_BIT_OBJECTS = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String db;
    private @Nullable String refs;
    private @Nullable String tags;
    private @Nullable String objects;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MongoDbConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MongoCommand.MongoDbConfig instance) {
      Objects.requireNonNull(instance, "instance");
      db(instance.getDb());
      refs(instance.getRefs());
      tags(instance.getTags());
      objects(instance.getObjects());
      return this;
    }

    /**
     * Initializes the value for the {@link MongoCommand.MongoDbConfig#getDb() db} attribute.
     * @param db The value for db 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder db(String db) {
      this.db = Objects.requireNonNull(db, "db");
      initBits &= ~INIT_BIT_DB;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoCommand.MongoDbConfig#getRefs() refs} attribute.
     * @param refs The value for refs 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder refs(String refs) {
      this.refs = Objects.requireNonNull(refs, "refs");
      initBits &= ~INIT_BIT_REFS;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoCommand.MongoDbConfig#getTags() tags} attribute.
     * @param tags The value for tags 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tags(String tags) {
      this.tags = Objects.requireNonNull(tags, "tags");
      initBits &= ~INIT_BIT_TAGS;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoCommand.MongoDbConfig#getObjects() objects} attribute.
     * @param objects The value for objects 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder objects(String objects) {
      this.objects = Objects.requireNonNull(objects, "objects");
      initBits &= ~INIT_BIT_OBJECTS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongoDbConfig ImmutableMongoDbConfig}.
     * @return An immutable instance of MongoDbConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongoDbConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMongoDbConfig(db, refs, tags, objects);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DB) != 0) attributes.add("db");
      if ((initBits & INIT_BIT_REFS) != 0) attributes.add("refs");
      if ((initBits & INIT_BIT_TAGS) != 0) attributes.add("tags");
      if ((initBits & INIT_BIT_OBJECTS) != 0) attributes.add("objects");
      return "Cannot build MongoDbConfig, some of required attributes are not set " + attributes;
    }
  }
}
