/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

public class LoggedOutputStream
extends ServletOutputStream {
    private final int limit;
    private ByteArrayOutputStream logged;
    private int logged_bytes = 0;
    private final OutputStream output;
    private boolean overflowed = false;
    private boolean isClosed;

    public LoggedOutputStream(OutputStream output) {
        this(output, 0x100000);
    }

    public LoggedOutputStream(OutputStream output, int limit) {
        if (output == null) {
            throw new IllegalArgumentException("Null output");
        }
        this.limit = limit;
        this.logged = new ByteArrayOutputStream();
        this.output = output;
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.output.close();
        }
        catch (Throwable throwable) {
            try {
                this.logged.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.isClosed = true;
            }
            throw throwable;
        }
        try {
            this.logged.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.isClosed = true;
        }
    }

    public void flush() throws IOException {
        try {
            this.output.flush();
        }
        finally {
            try {
                this.logged.flush();
            }
            catch (IOException iOException) {}
        }
    }

    public byte[] logged() {
        if (this.overflowed) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            pw.print("{ \"overflowed\": ");
            pw.print(this.logged_bytes);
            pw.print(" }");
            pw.flush();
            return baos.toByteArray();
        }
        return this.logged.toByteArray();
    }

    public boolean overflowed() {
        return this.overflowed;
    }

    public void write(int b) throws IOException {
        try {
            this.output.write(b);
        }
        finally {
            this.logged_bytes += 4;
            if (this.logged_bytes > this.limit) {
                this.overflowed = true;
                this.logged = null;
            } else {
                this.logged.write(b);
            }
        }
    }

    public void write(byte[] b) throws IOException {
        try {
            this.output.write(b);
        }
        finally {
            try {
                this.logged_bytes += b.length;
                if (this.logged_bytes > this.limit) {
                    this.overflowed = true;
                    this.logged = null;
                } else {
                    this.logged.write(b);
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.output.write(b, off, len);
        }
        finally {
            this.logged_bytes += len;
            if (this.logged_bytes > this.limit) {
                this.overflowed = true;
                this.logged = null;
            } else {
                this.logged.write(b, off, len);
            }
        }
    }

    public boolean isReady() {
        return !this.isClosed;
    }

    public void setWriteListener(WriteListener writeListener) {
        throw new UnsupportedOperationException();
    }
}

