/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

public class LoggedInputStream
extends ServletInputStream {
    private byte[] logged;
    private final ByteArrayInputStream stream;

    public LoggedInputStream(InputStream input) throws IOException {
        this(input, 0x100000);
    }

    public LoggedInputStream(InputStream input, int limit) throws IOException {
        int len;
        if (input == null) {
            throw new IllegalArgumentException("Null input");
        }
        int logged_bytes = 0;
        boolean overflowed = false;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = input.read(buf)) > 0) {
            if ((logged_bytes += len) > limit) {
                overflowed = true;
                continue;
            }
            os.write(buf, 0, len);
        }
        if (overflowed) {
            os = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(os);
            pw.print("{ \"overflowed\": ");
            pw.print(logged_bytes);
            pw.print(" }");
            pw.flush();
        }
        this.logged = os.toByteArray();
        this.stream = new ByteArrayInputStream(this.logged);
    }

    public int available() {
        return this.stream.available();
    }

    public void close() throws IOException {
        this.logged = null;
        this.stream.close();
    }

    public byte[] logged() {
        return this.logged;
    }

    public int read() {
        return this.stream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    public boolean isFinished() {
        return this.stream.available() == 0;
    }

    public boolean isReady() {
        return this.stream.available() != 0;
    }

    public void setReadListener(ReadListener readListener) {
        throw new UnsupportedOperationException();
    }
}

