/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import io.resurface.HttpLogger;
import io.resurface.LoggedInputStream;
import io.resurface.LoggedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;

@Provider
public class HttpLoggerForJersey
implements ContainerRequestFilter,
ContainerResponseFilter,
ReaderInterceptor,
WriterInterceptor {
    protected final HttpLogger logger;

    public HttpLoggerForJersey(String url) {
        this.logger = new HttpLogger(url);
    }

    public HttpLoggerForJersey(String url, String rules) {
        this.logger = new HttpLogger(url, rules);
    }

    public HttpLoggerForJersey(List<String> queue) {
        this.logger = new HttpLogger(queue);
    }

    public HttpLoggerForJersey(List<String> queue, String rules) {
        this.logger = new HttpLogger(queue, rules);
    }

    public HttpLogger getLogger() {
        return this.logger;
    }

    public void filter(ContainerRequestContext context) {
        context.setProperty("resurfaceio.start", (Object)System.nanoTime());
    }

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        if (this.logger.enabled) {
            LoggedInputStream lis = new LoggedInputStream(context.getInputStream());
            context.setProperty("resurfaceio.requestBodyBytes", (Object)lis.logged());
            context.setInputStream((InputStream)((Object)lis));
        }
        return context.proceed();
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        String formatted_url;
        if (!this.logger.enabled) {
            return;
        }
        ArrayList<String[]> message = new ArrayList<String[]>();
        String method = request.getMethod();
        if (method != null) {
            message.add(new String[]{"request_method", method});
        }
        if ((formatted_url = request.getUriInfo().getRequestUri().toString()) != null) {
            message.add(new String[]{"request_url", formatted_url});
        }
        message.add(new String[]{"response_code", String.valueOf(response.getStatus())});
        HttpLoggerForJersey.appendRequestHeaders(message, request);
        HttpLoggerForJersey.appendRequestParams(message, request);
        HttpLoggerForJersey.appendResponseHeaders(message, response);
        request.setProperty("resurfaceio.message", message);
    }

    private static void appendRequestHeaders(List<String[]> message, ContainerRequestContext request) {
        for (Map.Entry x : request.getHeaders().entrySet()) {
            String name = "request_header:" + ((String)x.getKey()).toLowerCase();
            for (String xv : (List)x.getValue()) {
                message.add(new String[]{name, xv});
            }
        }
    }

    private static void appendRequestParams(List<String[]> message, ContainerRequestContext request) {
        for (Map.Entry x : request.getUriInfo().getQueryParameters(true).entrySet()) {
            String name = "request_param:" + ((String)x.getKey()).toLowerCase();
            for (String xv : (List)x.getValue()) {
                message.add(new String[]{name, xv});
            }
        }
    }

    private static void appendResponseHeaders(List<String[]> message, ContainerResponseContext response) {
        for (Map.Entry x : response.getStringHeaders().entrySet()) {
            String name = "response_header:" + ((String)x.getKey()).toLowerCase();
            for (String xv : (List)x.getValue()) {
                message.add(new String[]{name, xv});
            }
        }
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        if (this.logger.enabled) {
            String response_body;
            String request_body;
            List message = (List)context.getProperty("resurfaceio.message");
            LoggedOutputStream los = new LoggedOutputStream(context.getOutputStream());
            context.setOutputStream((OutputStream)((Object)los));
            context.proceed();
            byte[] rbb = (byte[])context.getProperty("resurfaceio.requestBodyBytes");
            String string = request_body = rbb == null ? null : new String(rbb, StandardCharsets.UTF_8);
            if (request_body != null && !request_body.equals("")) {
                message.add(new String[]{"request_body", request_body});
            }
            if (!(response_body = new String(los.logged(), StandardCharsets.UTF_8)).equals("")) {
                message.add(new String[]{"response_body", response_body});
            }
            message.add(new String[]{"now", String.valueOf(System.currentTimeMillis())});
            double interval = (double)(System.nanoTime() - (Long)context.getProperty("resurfaceio.start")) / 1000000.0;
            message.add(new String[]{"interval", String.valueOf(interval)});
            HashMap<String, String> customFields = new HashMap<String, String>();
            this.logger.submitIfPassing(message, customFields);
        } else {
            context.proceed();
        }
    }
}

