/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import io.resurface.BaseLogger;
import java.util.concurrent.atomic.AtomicInteger;

public class Dispatcher
implements Runnable {
    private final BaseLogger logger;
    private StringBuilder buffer;
    private final int batchingThreshold;
    private final AtomicInteger full_buffer_count = new AtomicInteger();
    private final AtomicInteger empty_queue_count = new AtomicInteger();

    public Dispatcher(BaseLogger logger, int threshold) {
        this.logger = logger;
        this.batchingThreshold = threshold;
        this.buffer = new StringBuilder(this.batchingThreshold + 5120);
    }

    @Override
    public void run() {
        try {
            while (true) {
                String msg;
                if (this.buffer.length() >= this.batchingThreshold || this.logger.msg_queue.peek() == null) {
                    this.flushAndDispatch();
                }
                if ((msg = this.logger.msg_queue.take()).equals("POISON PILL")) {
                    this.flushAndDispatch();
                    break;
                }
                this.buffer.append(msg).append("\n");
            }
        }
        catch (InterruptedException e) {
            this.flushAndDispatch();
        }
    }

    private void flushAndDispatch() {
        if (this.buffer.length() != 0) {
            if (this.buffer.length() >= this.batchingThreshold) {
                this.full_buffer_count.incrementAndGet();
            }
            if (this.logger.msg_queue.peek() == null) {
                this.empty_queue_count.incrementAndGet();
            }
            String msg = this.buffer.toString();
            this.buffer = new StringBuilder();
            this.logger.dispatch(msg);
        }
    }
}

