/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import io.resurface.LoggedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class LoggedResponseWrapper
extends HttpServletResponseWrapper {
    public static final byte[] LOGGED_NOTHING = new byte[0];
    private final HttpServletResponse response;
    private LoggedOutputStream stream;
    private PrintWriter writer;

    public LoggedResponseWrapper(HttpServletResponse response) {
        super(response);
        this.response = response;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        super.flushBuffer();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.stream == null) {
            this.stream = new LoggedOutputStream((OutputStream)this.response.getOutputStream());
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            String encoding = this.getCharacterEncoding();
            encoding = encoding == null ? "ISO-8859-1" : encoding;
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), encoding));
        }
        return this.writer;
    }

    public byte[] logged() {
        return this.stream == null ? LOGGED_NOTHING : this.stream.logged();
    }
}

