/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import io.resurface.BaseServletRequestImpl;
import io.resurface.HttpSessionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class HttpServletRequestImpl
extends BaseServletRequestImpl {
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private String method;
    private final Map<String, List<String>> params = new HashMap<String, List<String>>();
    private String queryString;
    private String requestURL;
    private HttpSession session;

    public void addHeader(String name, String value) {
        if (this.headers.containsKey(name)) {
            this.headers.get(name).add(value);
        } else {
            this.setHeader(name, value);
        }
    }

    public void addParam(String name, String value) {
        if (this.params.containsKey(name)) {
            this.params.get(name).add(value);
        } else {
            this.setParam(name, value);
        }
    }

    @Override
    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    @Override
    public String getHeader(String name) {
        return this.headers.containsKey(name) ? this.headers.get(name).get(0) : null;
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        return this.headers.containsKey(name) ? Collections.enumeration((Collection)this.headers.get(name)) : null;
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        return values == null || values.length == 0 ? null : values[0];
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.params.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        List<String> values = this.params.get(name);
        if (values == null) {
            return null;
        }
        String[] results = new String[values.size()];
        results = values.toArray(results);
        return results;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public StringBuffer getRequestURL() {
        return this.requestURL == null ? null : new StringBuffer(this.requestURL);
    }

    @Override
    public HttpSession getSession(boolean create) {
        if (create && this.session == null) {
            this.session = new HttpSessionImpl();
        }
        return this.session;
    }

    public void setContentType(String contentType) {
        this.setHeader("Content-Type", contentType);
    }

    public void setHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.headers.put(name, values);
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setParam(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.params.put(name, values);
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setRequestURL(String requestURL) {
        this.requestURL = requestURL;
    }
}

