/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import io.resurface.HttpLogger;
import io.resurface.HttpMessage;
import io.resurface.LoggedResponseWrapper;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpLoggerForServlets
implements Filter {
    protected FilterConfig config;
    protected HttpLogger logger;
    protected final List<String> queue;
    protected final String rules;

    public HttpLoggerForServlets() {
        this.queue = null;
        this.rules = null;
    }

    public HttpLoggerForServlets(List<String> queue, String rules) {
        this.queue = queue;
        this.rules = rules;
    }

    public HttpLogger getLogger() {
        return this.logger;
    }

    public void init(FilterConfig config) {
        this.config = config;
        this.logger = this.queue != null ? new HttpLogger(this.queue, this.rules) : (config != null ? new HttpLogger(config.getInitParameter("url"), config.getInitParameter("rules")) : new HttpLogger());
    }

    public void destroy() {
        this.config = null;
        this.logger = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.logger.isEnabled()) {
            this.log((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    protected void log(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        long start = System.nanoTime();
        LoggedResponseWrapper response_wrapper = new LoggedResponseWrapper(response);
        chain.doFilter((ServletRequest)request, (ServletResponse)response_wrapper);
        response_wrapper.flushBuffer();
        String response_encoding = response.getCharacterEncoding();
        response_encoding = response_encoding == null ? "ISO-8859-1" : response_encoding;
        String response_body = new String(response_wrapper.logged(), response_encoding);
        long now = System.currentTimeMillis();
        double interval = (double)(System.nanoTime() - start) / 1000000.0;
        HttpMessage.send(this.logger, request, response, response_body, null, now, interval);
    }
}

