/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import io.resurface.BaseLogger;
import io.resurface.HttpRules;
import io.resurface.Json;
import java.util.List;
import java.util.regex.Pattern;

public class HttpLogger
extends BaseLogger<HttpLogger> {
    public static final String AGENT = "HttpLogger.java";
    protected HttpRules rules;
    protected static final String STRING_TYPES = "(?i)^text/(html|plain|xml)|application/(json|soap|xml|x-www-form-urlencoded)";
    protected static final Pattern STRING_TYPES_REGEX = Pattern.compile("(?i)^text/(html|plain|xml)|application/(json|soap|xml|x-www-form-urlencoded)");

    public HttpLogger() {
        super(AGENT);
        this.initialize(null);
    }

    public HttpLogger(boolean enabled) {
        super(AGENT, enabled);
        this.initialize(null);
    }

    public HttpLogger(String url) {
        super(AGENT, url);
        this.initialize(null);
    }

    public HttpLogger(String url, String rules) {
        super(AGENT, url);
        this.initialize(rules);
    }

    public HttpLogger(String url, boolean enabled) {
        super(AGENT, url, enabled);
        this.initialize(null);
    }

    public HttpLogger(String url, boolean enabled, String rules) {
        super(AGENT, url, enabled);
        this.initialize(rules);
    }

    public HttpLogger(List<String> queue) {
        super(AGENT, queue);
        this.initialize(null);
    }

    public HttpLogger(List<String> queue, String rules) {
        super(AGENT, queue);
        this.initialize(rules);
    }

    public HttpLogger(List<String> queue, boolean enabled) {
        super(AGENT, queue, enabled);
        this.initialize(null);
    }

    public HttpLogger(List<String> queue, boolean enabled, String rules) {
        super(AGENT, queue, enabled);
        this.initialize(rules);
    }

    private void initialize(String rules) {
        this.rules = new HttpRules(rules);
        this.skip_compression = this.rules.skip_compression;
        this.skip_submission = this.rules.skip_submission;
        if (this.url != null && this.url.startsWith("http:") && !this.rules.allow_http_url) {
            this.enableable = false;
            this.enabled = false;
        }
    }

    public HttpRules getRules() {
        return this.rules;
    }

    public void submitIfPassing(List<String[]> details) {
        if ((details = this.rules.apply(details)) == null) {
            return;
        }
        details.add(new String[]{"agent", this.agent});
        details.add(new String[]{"host", this.host});
        details.add(new String[]{"version", this.version});
        this.submit(Json.stringify(details));
    }

    public static boolean isStringContentType(String s) {
        return s != null && STRING_TYPES_REGEX.matcher(s).find();
    }
}

