/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import io.resurface.HttpLogger;
import io.resurface.HttpRule;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class HttpMessage {
    public static void send(HttpLogger logger, HttpServletRequest request, HttpServletResponse response) {
        HttpMessage.send(logger, request, response, null, null, 0L, 0L);
    }

    public static void send(HttpLogger logger, HttpServletRequest request, HttpServletResponse response, String response_body) {
        HttpMessage.send(logger, request, response, response_body, null, 0L, 0L);
    }

    public static void send(HttpLogger logger, HttpServletRequest request, HttpServletResponse response, String response_body, String request_body) {
        HttpMessage.send(logger, request, response, response_body, request_body, 0L, 0L);
    }

    public static void send(HttpLogger logger, HttpServletRequest request, HttpServletResponse response, String response_body, String request_body, long now, long interval) {
        HttpSession ssn;
        if (!logger.isEnabled()) {
            return;
        }
        List<String[]> details = HttpMessage.build(request, response, response_body, request_body);
        if (!logger.getRules().copy_session_field.isEmpty() && (ssn = request.getSession(false)) != null) {
            for (HttpRule r : logger.getRules().copy_session_field) {
                Enumeration names = ssn.getAttributeNames();
                while (names.hasMoreElements()) {
                    String d = (String)names.nextElement();
                    if (!((Pattern)r.param1).matcher(d).matches()) continue;
                    String val = ssn.getAttribute(d).toString();
                    details.add(new String[]{"session_field:" + d, val});
                }
            }
        }
        if (now == 0L) {
            now = System.currentTimeMillis();
        }
        details.add(new String[]{"now", String.valueOf(now)});
        if (interval != 0L) {
            details.add(new String[]{"interval", String.valueOf(interval)});
        }
        logger.submitIfPassing(details);
    }

    public static List<String[]> build(HttpServletRequest request, HttpServletResponse response, String response_body, String request_body) {
        String formatted_url;
        ArrayList<String[]> message = new ArrayList<String[]>();
        if (request.getMethod() != null) {
            message.add(new String[]{"request_method", request.getMethod()});
        }
        if ((formatted_url = HttpMessage.formatURL(request)) != null) {
            message.add(new String[]{"request_url", formatted_url});
        }
        message.add(new String[]{"response_code", String.valueOf(response.getStatus())});
        HttpMessage.appendRequestHeaders(message, request);
        HttpMessage.appendRequestParams(message, request);
        HttpMessage.appendResponseHeaders(message, response);
        if (request_body != null && !request_body.equals("")) {
            message.add(new String[]{"request_body", request_body});
        }
        if (response_body != null && !response_body.equals("")) {
            message.add(new String[]{"response_body", response_body});
        }
        return message;
    }

    private static void appendRequestHeaders(List<String[]> message, HttpServletRequest request) {
        Enumeration header_names = request.getHeaderNames();
        while (header_names.hasMoreElements()) {
            String name = (String)header_names.nextElement();
            Enumeration e = request.getHeaders(name);
            name = "request_header:" + name.toLowerCase();
            while (e.hasMoreElements()) {
                message.add(new String[]{name, (String)e.nextElement()});
            }
        }
    }

    private static void appendRequestParams(List<String[]> message, HttpServletRequest request) {
        Enumeration param_names = request.getParameterNames();
        while (param_names.hasMoreElements()) {
            String name = (String)param_names.nextElement();
            String[] values = request.getParameterValues(name);
            if (values == null) continue;
            name = "request_param:" + name.toLowerCase();
            for (String value : values) {
                message.add(new String[]{name, value});
            }
        }
    }

    private static void appendResponseHeaders(List<String[]> message, HttpServletResponse response) {
        for (String name : response.getHeaderNames()) {
            Iterator i = response.getHeaders(name).iterator();
            name = "response_header:" + name.toLowerCase();
            while (i.hasNext()) {
                message.add(new String[]{name, (String)i.next()});
            }
        }
    }

    private static String formatURL(HttpServletRequest request) {
        String queryString;
        StringBuffer url = request.getRequestURL();
        if (url != null && (queryString = request.getQueryString()) != null) {
            url.append('?').append(queryString);
        }
        return url == null ? null : url.toString();
    }
}

