/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import io.resurface.UsageLoggers;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DeflaterOutputStream;

public class BaseLogger<T extends BaseLogger> {
    protected final String agent;
    protected boolean enableable;
    protected boolean enabled;
    protected final String host;
    protected final List<String> queue;
    protected boolean skip_compression = false;
    protected boolean skip_submission = false;
    protected AtomicInteger submit_failures = new AtomicInteger();
    protected String url;
    protected final String version;

    public BaseLogger(String agent) {
        this(agent, true);
    }

    public BaseLogger(String agent, boolean enabled) {
        this(agent, UsageLoggers.urlByDefault(), enabled);
    }

    public BaseLogger(String agent, String url) {
        this(agent, url, true);
    }

    public BaseLogger(String agent, String url, boolean enabled) {
        this.agent = agent;
        this.host = BaseLogger.host_lookup();
        this.version = BaseLogger.version_lookup();
        this.queue = null;
        this.enabled = enabled;
        if (url == null) {
            this.url = UsageLoggers.urlByDefault();
            if (this.url == null) {
                this.enabled = false;
            }
        } else {
            this.url = url;
        }
        if (this.url != null) {
            try {
                if (!new URL(this.url).getProtocol().contains("http")) {
                    throw new RuntimeException();
                }
            }
            catch (Exception e) {
                this.url = null;
                this.enabled = false;
            }
        }
        this.enableable = this.url != null;
    }

    public BaseLogger(String agent, List<String> queue) {
        this(agent, queue, true);
    }

    public BaseLogger(String agent, List<String> queue, boolean enabled) {
        this.agent = agent;
        this.host = BaseLogger.host_lookup();
        this.version = BaseLogger.version_lookup();
        this.enabled = enabled;
        this.queue = queue;
        this.url = null;
        this.enableable = this.queue != null;
    }

    public T disable() {
        this.enabled = false;
        return (T)this;
    }

    public T enable() {
        if (this.enableable) {
            this.enabled = true;
        }
        return (T)this;
    }

    public String getAgent() {
        return this.agent;
    }

    public String getHost() {
        return this.host;
    }

    public List<String> getQueue() {
        return this.queue;
    }

    public boolean getSkipCompression() {
        return this.skip_compression;
    }

    public boolean getSkipSubmission() {
        return this.skip_submission;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isEnableable() {
        return this.enableable;
    }

    public boolean isEnabled() {
        return this.enabled && UsageLoggers.isEnabled();
    }

    public void setSkipCompression(boolean skip_compression) {
        this.skip_compression = skip_compression;
    }

    public void setSkipSubmission(boolean skip_submission) {
        this.skip_submission = skip_submission;
    }

    public void submit(String msg) {
        if (msg != null && !this.skip_submission && this.isEnabled()) {
            if (this.queue != null) {
                this.queue.add(msg);
            } else {
                try {
                    URL url_parsed = new URL(this.url);
                    HttpURLConnection url_connection = (HttpURLConnection)url_parsed.openConnection();
                    url_connection.setConnectTimeout(5000);
                    url_connection.setReadTimeout(1000);
                    url_connection.setRequestMethod("POST");
                    url_connection.setDoOutput(true);
                    if (!this.skip_compression) {
                        url_connection.setRequestProperty("Content-Encoding", "deflated");
                    }
                    try (OutputStream os = url_connection.getOutputStream();){
                        if (this.skip_compression) {
                            os.write(msg.getBytes());
                        } else {
                            try (DeflaterOutputStream dos = new DeflaterOutputStream(os, true);){
                                dos.write(msg.getBytes());
                                dos.finish();
                                dos.flush();
                            }
                        }
                        os.flush();
                    }
                    if (url_connection.getResponseCode() != 204) {
                        this.submit_failures.incrementAndGet();
                    }
                }
                catch (Exception e) {
                    this.submit_failures.incrementAndGet();
                }
            }
        }
    }

    public int getSubmitFailures() {
        return this.submit_failures.get();
    }

    public static String host_lookup() {
        String dyno = System.getenv("DYNO");
        if (dyno != null) {
            return dyno;
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public static String version_lookup() {
        return "2.0.0";
    }
}

