/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;

public class LoggedOutputStream
extends ServletOutputStream {
    private final ByteArrayOutputStream logged;
    private final OutputStream output;

    public LoggedOutputStream(OutputStream output) {
        if (output == null) {
            throw new IllegalArgumentException("Null output");
        }
        this.logged = new ByteArrayOutputStream();
        this.output = output;
    }

    public void close() throws IOException {
        try {
            this.output.close();
        }
        finally {
            try {
                this.logged.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void flush() throws IOException {
        try {
            this.output.flush();
        }
        finally {
            try {
                this.logged.flush();
            }
            catch (IOException iOException) {}
        }
    }

    public byte[] logged() {
        return this.logged.toByteArray();
    }

    public void write(int b) throws IOException {
        try {
            this.output.write(b);
        }
        finally {
            this.logged.write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        try {
            this.output.write(b);
        }
        finally {
            try {
                this.logged.write(b);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.output.write(b, off, len);
        }
        finally {
            this.logged.write(b, off, len);
        }
    }
}

