/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;

public class LoggedInputStream
extends ServletInputStream {
    private byte[] logged;
    private final ByteArrayInputStream stream;

    public LoggedInputStream(byte[] input) {
        if (input == null) {
            throw new IllegalArgumentException("Null input");
        }
        this.logged = input;
        this.stream = new ByteArrayInputStream(this.logged);
    }

    public LoggedInputStream(InputStream input) throws IOException {
        int len;
        if (input == null) {
            throw new IllegalArgumentException("Null input");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = input.read(buf)) > 0) {
            os.write(buf, 0, len);
        }
        this.logged = os.toByteArray();
        this.stream = new ByteArrayInputStream(this.logged);
    }

    public int available() {
        return this.stream.available();
    }

    public void close() throws IOException {
        this.logged = null;
        this.stream.close();
    }

    public byte[] logged() {
        return this.logged;
    }

    public int read() {
        return this.stream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }
}

