/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpMessage {
    public static List<String[]> build(HttpServletRequest request, HttpServletResponse response, String response_body, String request_body) {
        ArrayList<String[]> message = new ArrayList<String[]>();
        message.add(new String[]{"request_method", request.getMethod()});
        String formatted_url = HttpMessage.formatURL(request);
        if (formatted_url != null) {
            message.add(new String[]{"request_url", formatted_url});
        }
        message.add(new String[]{"response_code", String.valueOf(response.getStatus())});
        HttpMessage.appendRequestHeaders(message, request);
        HttpMessage.appendRequestParams(message, request);
        HttpMessage.appendResponseHeaders(message, response);
        if (request_body != null && !request_body.equals("")) {
            message.add(new String[]{"request_body", request_body});
        }
        if (response_body != null && !response_body.equals("")) {
            message.add(new String[]{"response_body", response_body});
        }
        return message;
    }

    private static void appendRequestHeaders(List<String[]> message, HttpServletRequest request) {
        Enumeration header_names = request.getHeaderNames();
        while (header_names.hasMoreElements()) {
            String name = (String)header_names.nextElement();
            Enumeration e = request.getHeaders(name);
            name = "request_header:" + name.toLowerCase();
            while (e.hasMoreElements()) {
                message.add(new String[]{name, (String)e.nextElement()});
            }
        }
    }

    private static void appendRequestParams(List<String[]> message, HttpServletRequest request) {
        Enumeration param_names = request.getParameterNames();
        while (param_names.hasMoreElements()) {
            String name = (String)param_names.nextElement();
            String[] values = request.getParameterValues(name);
            if (values == null) continue;
            name = "request_param:" + name.toLowerCase();
            for (String value : values) {
                message.add(new String[]{name, value});
            }
        }
    }

    private static void appendResponseHeaders(List<String[]> message, HttpServletResponse response) {
        for (String name : response.getHeaderNames()) {
            Iterator i = response.getHeaders(name).iterator();
            name = "response_header:" + name.toLowerCase();
            while (i.hasNext()) {
                message.add(new String[]{name, (String)i.next()});
            }
        }
    }

    private static String formatURL(HttpServletRequest request) {
        String queryString;
        StringBuffer url = request.getRequestURL();
        if (url != null && (queryString = request.getQueryString()) != null) {
            url.append('?').append(queryString);
        }
        return url == null ? null : url.toString();
    }
}

