/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import io.resurface.HttpLogger;
import io.resurface.HttpServletRequestImpl;
import io.resurface.HttpServletResponseImpl;
import io.resurface.LoggedInputStream;
import io.resurface.LoggedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;

@Provider
public class HttpLoggerForJersey
implements ContainerResponseFilter,
ReaderInterceptor,
WriterInterceptor {
    protected final HttpLogger logger;

    public HttpLoggerForJersey(String url) {
        this.logger = new HttpLogger(url);
    }

    public HttpLoggerForJersey(String url, String rules) {
        this.logger = new HttpLogger(url, rules);
    }

    public HttpLoggerForJersey(List<String> queue) {
        this.logger = new HttpLogger(queue);
    }

    public HttpLoggerForJersey(List<String> queue, String rules) {
        this.logger = new HttpLogger(queue, rules);
    }

    public HttpLogger getLogger() {
        return this.logger;
    }

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        if (this.logger.enabled) {
            LoggedInputStream lis = new LoggedInputStream(context.getInputStream());
            context.setProperty("resurfaceio.requestBodyBytes", (Object)lis.logged());
            context.setInputStream((InputStream)((Object)lis));
        }
        return context.proceed();
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        if (!this.logger.enabled) {
            return;
        }
        HttpServletRequestImpl requestImpl = new HttpServletRequestImpl();
        requestImpl.setMethod(request.getMethod());
        requestImpl.setRequestURL(request.getUriInfo().getRequestUri().toString());
        for (Map.Entry x : request.getHeaders().entrySet()) {
            for (String xv : (List)x.getValue()) {
                requestImpl.addHeader((String)x.getKey(), xv);
            }
        }
        for (Map.Entry x : request.getUriInfo().getQueryParameters(true).entrySet()) {
            for (String xv : (List)x.getValue()) {
                requestImpl.addParam((String)x.getKey(), xv);
            }
        }
        request.setProperty("resurfaceio.request", (Object)requestImpl);
        HttpServletResponseImpl responseImpl = new HttpServletResponseImpl();
        responseImpl.setStatus(response.getStatus());
        for (Map.Entry x : response.getStringHeaders().entrySet()) {
            for (String xv : (List)x.getValue()) {
                responseImpl.addHeader((String)x.getKey(), xv);
            }
        }
        request.setProperty("resurfaceio.response", (Object)responseImpl);
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        HttpServletResponseImpl response = (HttpServletResponseImpl)context.getProperty("resurfaceio.response");
        if (this.logger.enabled && (response.getStatus() < 300 || response.getStatus() == 302)) {
            LoggedOutputStream los = new LoggedOutputStream(context.getOutputStream());
            context.setOutputStream((OutputStream)((Object)los));
            context.proceed();
            String responseBody = new String(los.logged(), StandardCharsets.UTF_8);
            byte[] rbb = (byte[])context.getProperty("resurfaceio.requestBodyBytes");
            String requestBody = rbb == null ? null : new String(rbb, StandardCharsets.UTF_8);
            HttpServletRequestImpl request = (HttpServletRequestImpl)context.getProperty("resurfaceio.request");
            this.logger.submit(this.logger.format(request, response, responseBody, requestBody));
        } else {
            context.proceed();
        }
    }
}

