/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import io.resurface.BaseLogger;
import io.resurface.HttpMessage;
import io.resurface.HttpRule;
import io.resurface.HttpRules;
import io.resurface.Json;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpLogger
extends BaseLogger<HttpLogger> {
    public static final String AGENT = "HttpLogger.java";
    private static String defaultRules = HttpRules.getStrictRules();
    private static final String STRING_TYPES = "(?i)^text/(html|plain|xml)|application/(json|soap|xml|x-www-form-urlencoded)";
    private static final Pattern STRING_TYPES_REGEX = Pattern.compile("(?i)^text/(html|plain|xml)|application/(json|soap|xml|x-www-form-urlencoded)");
    private final Random random = new Random();
    private String rules;
    private boolean rules_allow_http_url;
    private List<HttpRule> rules_copy_session_field;
    private List<HttpRule> rules_remove;
    private List<HttpRule> rules_remove_if;
    private List<HttpRule> rules_remove_if_found;
    private List<HttpRule> rules_remove_unless;
    private List<HttpRule> rules_remove_unless_found;
    private List<HttpRule> rules_replace;
    private List<HttpRule> rules_sample;
    private List<HttpRule> rules_stop;
    private List<HttpRule> rules_stop_if;
    private List<HttpRule> rules_stop_if_found;
    private List<HttpRule> rules_stop_unless;
    private List<HttpRule> rules_stop_unless_found;

    public static String getDefaultRules() {
        return defaultRules;
    }

    public static void setDefaultRules(String r) {
        defaultRules = r.replaceAll("(?m)^\\s*include default\\s*$", "");
    }

    public static boolean isStringContentType(String s) {
        return s != null && STRING_TYPES_REGEX.matcher(s).find();
    }

    public HttpLogger() {
        super(AGENT);
        this.initialize(null);
    }

    public HttpLogger(boolean enabled) {
        super(AGENT, enabled);
        this.initialize(null);
    }

    public HttpLogger(String url) {
        super(AGENT, url);
        this.initialize(null);
    }

    public HttpLogger(String url, String rules) {
        super(AGENT, url);
        this.initialize(rules);
    }

    public HttpLogger(String url, boolean enabled) {
        super(AGENT, url, enabled);
        this.initialize(null);
    }

    public HttpLogger(String url, boolean enabled, String rules) {
        super(AGENT, url, enabled);
        this.initialize(rules);
    }

    public HttpLogger(List<String> queue) {
        super(AGENT, queue);
        this.initialize(null);
    }

    public HttpLogger(List<String> queue, String rules) {
        super(AGENT, queue);
        this.initialize(rules);
    }

    public HttpLogger(List<String> queue, boolean enabled) {
        super(AGENT, queue, enabled);
        this.initialize(null);
    }

    public HttpLogger(List<String> queue, boolean enabled, String rules) {
        super(AGENT, queue, enabled);
        this.initialize(rules);
    }

    private void initialize(String rules) {
        if (rules != null) {
            this.rules = rules.replaceAll("(?m)^\\s*include default\\s*$", Matcher.quoteReplacement(defaultRules));
            if (this.rules.trim().length() == 0) {
                this.rules = defaultRules;
            }
        } else {
            this.rules = defaultRules;
        }
        List<HttpRule> prs = HttpRules.parse(this.rules);
        this.rules_allow_http_url = prs.stream().anyMatch(r -> "allow_http_url".equals(r.verb));
        this.rules_copy_session_field = prs.stream().filter(r -> "copy_session_field".equals(r.verb)).collect(Collectors.toList());
        this.rules_remove = prs.stream().filter(r -> "remove".equals(r.verb)).collect(Collectors.toList());
        this.rules_remove_if = prs.stream().filter(r -> "remove_if".equals(r.verb)).collect(Collectors.toList());
        this.rules_remove_if_found = prs.stream().filter(r -> "remove_if_found".equals(r.verb)).collect(Collectors.toList());
        this.rules_remove_unless = prs.stream().filter(r -> "remove_unless".equals(r.verb)).collect(Collectors.toList());
        this.rules_remove_unless_found = prs.stream().filter(r -> "remove_unless_found".equals(r.verb)).collect(Collectors.toList());
        this.rules_replace = prs.stream().filter(r -> "replace".equals(r.verb)).collect(Collectors.toList());
        this.rules_sample = prs.stream().filter(r -> "sample".equals(r.verb)).collect(Collectors.toList());
        this.rules_stop = prs.stream().filter(r -> "stop".equals(r.verb)).collect(Collectors.toList());
        this.rules_stop_if = prs.stream().filter(r -> "stop_if".equals(r.verb)).collect(Collectors.toList());
        this.rules_stop_if_found = prs.stream().filter(r -> "stop_if_found".equals(r.verb)).collect(Collectors.toList());
        this.rules_stop_unless = prs.stream().filter(r -> "stop_unless".equals(r.verb)).collect(Collectors.toList());
        this.rules_stop_unless_found = prs.stream().filter(r -> "stop_unless_found".equals(r.verb)).collect(Collectors.toList());
        this.skip_compression = prs.stream().anyMatch(r -> "skip_compression".equals(r.verb));
        this.skip_submission = prs.stream().anyMatch(r -> "skip_submission".equals(r.verb));
        if (this.rules_sample.size() > 1) {
            throw new IllegalArgumentException("Multiple sample rules");
        }
        if (this.url != null && this.url.startsWith("http:") && !this.rules_allow_http_url) {
            this.enableable = false;
            this.enabled = false;
        }
    }

    public String getRules() {
        return this.rules;
    }

    public boolean log(HttpServletRequest request, HttpServletResponse response) {
        return this.log(request, response, null, null);
    }

    public boolean log(HttpServletRequest request, HttpServletResponse response, String response_body) {
        return this.log(request, response, response_body, null);
    }

    public boolean log(HttpServletRequest request, HttpServletResponse response, String response_body, String request_body) {
        return !this.isEnabled() || this.submit(this.format(request, response, response_body, request_body));
    }

    public String format(HttpServletRequest request, HttpServletResponse response) {
        return this.format(request, response, null, null, System.currentTimeMillis());
    }

    public String format(HttpServletRequest request, HttpServletResponse response, String response_body) {
        return this.format(request, response, response_body, null, System.currentTimeMillis());
    }

    public String format(HttpServletRequest request, HttpServletResponse response, String response_body, String request_body) {
        return this.format(request, response, response_body, request_body, System.currentTimeMillis());
    }

    public String format(HttpServletRequest request, HttpServletResponse response, String response_body, String request_body, long now) {
        Object ssn;
        List<String[]> details = HttpMessage.build(request, response, response_body, request_body);
        if (!this.rules_copy_session_field.isEmpty() && (ssn = request.getSession(false)) != null) {
            for (HttpRule httpRule : this.rules_copy_session_field) {
                Enumeration names = ssn.getAttributeNames();
                while (names.hasMoreElements()) {
                    String d2 = (String)names.nextElement();
                    if (!((Pattern)httpRule.param1).matcher(d2).matches()) continue;
                    String val = ssn.getAttribute(d2).toString();
                    details.add(new String[]{"session_field:" + d2, val});
                }
            }
        }
        for (HttpRule r : this.rules_stop) {
            for (String[] d3 : details) {
                if (!r.scope.matcher(d3[0]).matches()) continue;
                return null;
            }
        }
        for (HttpRule r : this.rules_stop_if_found) {
            for (String[] d2 : details) {
                if (!r.scope.matcher(d2[0]).matches() || !((Pattern)r.param1).matcher(d2[1]).find()) continue;
                return null;
            }
        }
        for (HttpRule r : this.rules_stop_if) {
            for (String[] d2 : details) {
                if (!r.scope.matcher(d2[0]).matches() || !((Pattern)r.param1).matcher(d2[1]).matches()) continue;
                return null;
            }
        }
        int passed = 0;
        for (HttpRule httpRule : this.rules_stop_unless_found) {
            for (String[] d3 : details) {
                if (!httpRule.scope.matcher(d3[0]).matches() || !((Pattern)httpRule.param1).matcher(d3[1]).find()) continue;
                ++passed;
            }
        }
        if (passed != this.rules_stop_unless_found.size()) {
            return null;
        }
        passed = 0;
        for (HttpRule httpRule : this.rules_stop_unless) {
            for (String[] d3 : details) {
                if (!httpRule.scope.matcher(d3[0]).matches() || !((Pattern)httpRule.param1).matcher(d3[1]).matches()) continue;
                ++passed;
            }
        }
        if (passed != this.rules_stop_unless.size()) {
            return null;
        }
        if (this.rules_sample.size() == 1 && this.random.nextInt(100) >= (Integer)this.rules_sample.get((int)0).param1) {
            return null;
        }
        for (HttpRule httpRule : this.rules_remove) {
            details.removeIf(d -> r.scope.matcher(d[0]).matches());
        }
        for (HttpRule httpRule : this.rules_remove_unless_found) {
            details.removeIf(d -> r.scope.matcher(d[0]).matches() && !((Pattern)r.param1).matcher(d[1]).find());
        }
        for (HttpRule httpRule : this.rules_remove_if_found) {
            details.removeIf(d -> r.scope.matcher(d[0]).matches() && ((Pattern)r.param1).matcher(d[1]).find());
        }
        for (HttpRule httpRule : this.rules_remove_unless) {
            details.removeIf(d -> r.scope.matcher(d[0]).matches() && !((Pattern)r.param1).matcher(d[1]).matches());
        }
        for (HttpRule httpRule : this.rules_remove_if) {
            details.removeIf(d -> r.scope.matcher(d[0]).matches() && ((Pattern)r.param1).matcher(d[1]).matches());
        }
        if (details.isEmpty()) {
            return null;
        }
        for (HttpRule httpRule : this.rules_replace) {
            for (String[] d3 : details) {
                if (!httpRule.scope.matcher(d3[0]).matches()) continue;
                d3[1] = ((Pattern)httpRule.param1).matcher(d3[1]).replaceAll((String)httpRule.param2);
            }
        }
        details.removeIf(d -> "".equals(d[1]));
        if (details.isEmpty()) {
            return null;
        }
        details.add(new String[]{"now", String.valueOf(now)});
        details.add(new String[]{"agent", this.agent});
        details.add(new String[]{"version", this.version});
        return Json.stringify(details);
    }
}

