/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import io.resurface.LoggedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class LoggedRequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, String[]> parameters;
    private BufferedReader reader;
    private final LoggedInputStream stream;
    private static final Map<String, String[]> PARAMETERS_NONE = new HashMap<String, String[]>(0);

    public LoggedRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.stream = new LoggedInputStream((InputStream)request.getInputStream());
    }

    public ServletInputStream getInputStream() {
        return this.stream;
    }

    public String getParameter(String name) {
        if (name == null) {
            return null;
        }
        this.parseParameters();
        String[] values = this.parameters.get(name);
        return values == null ? null : values[0];
    }

    public Map<String, String[]> getParameterMap() {
        this.parseParameters();
        return this.parameters;
    }

    public Enumeration<String> getParameterNames() {
        this.parseParameters();
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            return null;
        }
        this.parseParameters();
        return this.parameters.get(name);
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
        }
        return this.reader;
    }

    public byte[] logged() {
        byte[] buffer = this.stream.logged();
        return buffer == null ? new byte[]{} : buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseParameters() {
        String encoding;
        block9: {
            block8: {
                if (this.parameters != null) {
                    return;
                }
                String content_type = this.getRequest().getContentType();
                if (content_type != null && content_type.toLowerCase().contains("x-www-form-urlencoded")) break block8;
                this.parameters = this.parameters == null ? PARAMETERS_NONE : this.parameters;
                return;
            }
            encoding = this.getRequest().getCharacterEncoding();
            byte[] logged = this.stream.logged();
            if (encoding != null && logged != null) break block9;
            this.parameters = this.parameters == null ? PARAMETERS_NONE : this.parameters;
            return;
        }
        try {
            String body = new String(this.logged(), encoding);
            String[] pairs = body.split("&");
            this.parameters = new HashMap<String, String[]>(pairs.length);
            for (String pair : pairs) {
                String[] fields = pair.split("=");
                String name = URLDecoder.decode(fields[0], encoding);
                String value = URLDecoder.decode(fields[1], encoding);
                String[] values = this.parameters.get(name);
                if (values == null) {
                    this.parameters.put(name, new String[]{value});
                    continue;
                }
                int vlength = values.length;
                String[] new_values = new String[vlength + 1];
                System.arraycopy(values, 0, new_values, 0, vlength);
                new_values[vlength] = value;
                this.parameters.put(name, new_values);
            }
            this.parameters = this.parameters == null ? PARAMETERS_NONE : this.parameters;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.parameters = this.parameters == null ? PARAMETERS_NONE : this.parameters;
        }
        catch (Throwable throwable) {
            this.parameters = this.parameters == null ? PARAMETERS_NONE : this.parameters;
            throw throwable;
        }
    }
}

