/*
 * Decompiled with CFR 0.152.
 */
package io.resurface;

import io.resurface.HttpLogger;
import io.resurface.LoggedRequestWrapper;
import io.resurface.LoggedResponseWrapper;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpLoggerForServlets
implements Filter {
    protected FilterConfig config;
    protected HttpLogger logger;
    protected final List<String> queue;
    protected final String STRING_TYPES_REGEX = "(?i)^text/(html|plain|xml)|application/(json|soap|xml|x-www-form-urlencoded)";
    protected final Pattern STRING_TYPES_PATTERN = Pattern.compile("(?i)^text/(html|plain|xml)|application/(json|soap|xml|x-www-form-urlencoded)");

    public HttpLoggerForServlets() {
        this.queue = null;
    }

    public HttpLoggerForServlets(List<String> queue) {
        this.queue = queue;
    }

    public void init(FilterConfig config) {
        this.config = config;
        this.logger = this.queue != null ? new HttpLogger(this.queue) : (config != null ? new HttpLogger(config.getInitParameter("url")) : new HttpLogger());
    }

    public void destroy() {
        this.config = null;
        this.logger = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.logger.isEnabled()) {
            this.process((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    protected void process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String response_encoding;
        Object request_wrapper = null;
        String request_encoding = request.getCharacterEncoding();
        if (request_encoding != null && this.isStringContentType(request.getContentType())) {
            request_wrapper = new LoggedRequestWrapper(request);
        }
        LoggedResponseWrapper response_wrapper = new LoggedResponseWrapper(response);
        chain.doFilter((ServletRequest)(request_wrapper != null ? request_wrapper : request), (ServletResponse)response_wrapper);
        response_wrapper.flushBuffer();
        if (response.getStatus() != 304 && (response_encoding = response.getCharacterEncoding()) != null && this.isStringContentType(response.getContentType())) {
            String request_body = request_wrapper == null ? null : new String(((LoggedRequestWrapper)((Object)request_wrapper)).logged(), request_encoding);
            String response_body = new String(response_wrapper.logged(), response_encoding);
            this.logger.log(request, request_body, response, response_body);
        }
    }

    protected boolean isStringContentType(String s) {
        return s != null && this.STRING_TYPES_PATTERN.matcher(s).find();
    }
}

