package restx.monitor;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.monitor.MetricsResource;

@Machine
public class MetricsResourceFactoryMachine extends SingleNameFactoryMachine<restx.monitor.MetricsResource> {
    public static final Name<restx.monitor.MetricsResource> NAME = Name.of(restx.monitor.MetricsResource.class, "MetricsResource");

    public MetricsResourceFactoryMachine() {
        super(0, new StdMachineEngine<restx.monitor.MetricsResource>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.common.metrics.api.MetricRegistry> metricRegistry = Factory.Query.byClass(restx.common.metrics.api.MetricRegistry.class).mandatory();
private final Factory.Query<restx.common.metrics.api.health.HealthCheckRegistry> healthCheckRegistry = Factory.Query.byClass(restx.common.metrics.api.health.HealthCheckRegistry.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
metricRegistry,
healthCheckRegistry
                ));
            }

            @Override
            protected restx.monitor.MetricsResource doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new MetricsResource(
satisfiedBOM.getOne(metricRegistry).get().getComponent(),
satisfiedBOM.getOne(healthCheckRegistry).get().getComponent()
                );
            }
        });
    }

}
