/*
 * Decompiled with CFR 0.152.
 */
package restx.monitor;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import jakarta.validation.Validator;
import java.io.IOException;
import java.lang.reflect.Type;
import restx.RestxLogLevel;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.annotations.GET;
import restx.converters.MainStringConverter;
import restx.description.OperationDescription;
import restx.endpoint.Endpoint;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.entity.EntityRequestBodyReaderRegistry;
import restx.entity.EntityResponseWriterRegistry;
import restx.entity.StdEntityRoute;
import restx.exceptions.WrappedCheckedException;
import restx.factory.Component;
import restx.factory.ParamDef;
import restx.http.HttpStatus;
import restx.monitor.SessionsResource;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;
import restx.security.RolesAllowed;
import restx.security.Sessions;
import restx.types.Types;

@Component(priority=0)
public class SessionsResourceRouter
extends RestxRouter {
    public SessionsResourceRouter(final SessionsResource resource, EntityRequestBodyReaderRegistry readerRegistry, EntityResponseWriterRegistry writerRegistry, MainStringConverter converter, PermissionFactory pf, Optional<Validator> validator, final RestxSecurityManager securityManager, EndpointParameterMapperRegistry paramMapperRegistry) {
        super("restx-admin", "SessionsResourceRouter", new RestxRoute[]{new StdEntityRoute<Void, Iterable<Sessions.SessionData>>("restx-admin#SessionsResource#metrics", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build((Type)Types.newParameterizedType(Iterable.class, (Type[])new Type[]{Sessions.SessionData.class}), Optional.absent()), Endpoint.of((String)"GET", (String)"/@/sessionStats"), HttpStatus.OK, RestxLogLevel.DEFAULT, pf, paramMapperRegistry, new ParamDef[0]){

            protected Optional<Iterable<Sessions.SessionData>> doRoute(RestxRequest request, RestxResponse response, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, match, this.hasRole("restx-admin"));
                try {
                    return Optional.of(resource.metrics());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedCheckedException(e);
                }
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                operation.responseClass = "LIST[SessionData]";
                operation.inEntitySchemaKey = "";
                operation.inEntityType = Void.class;
                operation.outEntitySchemaKey = "restx.security.Sessions.SessionData";
                operation.outEntityType = Types.newParameterizedType(Iterable.class, (Type[])new Type[]{Sessions.SessionData.class});
                operation.sourceLocation = "restx.monitor.SessionsResource#metrics()";
                operation.annotations = ImmutableList.builder().add((Object)new RolesAllowed(){

                    public Class<RolesAllowed> annotationType() {
                        return RolesAllowed.class;
                    }

                    public String[] value() {
                        return new String[]{"restx-admin"};
                    }
                }).add((Object)new GET(){

                    public Class<GET> annotationType() {
                        return GET.class;
                    }

                    public String value() {
                        return "/@/sessionStats";
                    }
                }).build();
            }
        }});
    }
}

