/*
 * Decompiled with CFR 0.152.
 */
package restx.monitor;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.jvm.ThreadDeadlockHealthCheck;
import com.codahale.metrics.jmx.DefaultObjectNameFactory;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jmx.ObjectNameFactory;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.AppSettings;
import restx.common.metrics.api.health.HealthCheckRegistry;
import restx.factory.AutoStartable;
import restx.factory.Component;
import restx.metrics.codahale.CodahaleMetricRegistry;
import restx.metrics.codahale.health.CodahaleHealthCheckRegistry;
import restx.monitor.GraphiteSettings;

@Component
public class MetricsConfiguration
implements AutoStartable {
    private static final Logger logger = LoggerFactory.getLogger(MetricsConfiguration.class);
    private final MetricRegistry metrics;
    private final com.codahale.metrics.health.HealthCheckRegistry healthChecks;
    private final GraphiteSettings graphiteSettings;
    private final AppSettings appSettings;

    public MetricsConfiguration(restx.common.metrics.api.MetricRegistry metricRegistry, HealthCheckRegistry healthCheckRegistry, GraphiteSettings graphiteSettings, AppSettings appSettings) {
        if (!(metricRegistry instanceof CodahaleMetricRegistry)) {
            throw new IllegalStateException("restx-monitor-admin expects that module restx-monitor-codahale is loaded");
        }
        CodahaleMetricRegistry codahaleMetricRegistry = (CodahaleMetricRegistry)metricRegistry;
        CodahaleHealthCheckRegistry codahaleHealthCheckRegistry = (CodahaleHealthCheckRegistry)healthCheckRegistry;
        this.metrics = codahaleMetricRegistry.getCodahaleMetricRegistry();
        this.healthChecks = codahaleHealthCheckRegistry.getCodahaleHealthCheckRegistry();
        this.graphiteSettings = graphiteSettings;
        this.appSettings = appSettings;
    }

    public void start() {
        if ("prod".equals(this.appSettings.mode()) || "dev".equals(this.appSettings.mode())) {
            logger.info("registering Metrics JVM metrics");
            this.metrics.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
            this.metrics.register("jvm.garbage", (Metric)new GarbageCollectorMetricSet());
            this.metrics.register("jvm.threads", (Metric)new ThreadStatesGaugeSet());
            this.metrics.register("jvm.files", (Metric)new FileDescriptorRatioGauge());
            this.metrics.register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
            this.healthChecks.register("threadLocks", (HealthCheck)new ThreadDeadlockHealthCheck());
        }
        if ("prod".equals(this.appSettings.mode())) {
            this.setupReporters();
        }
    }

    protected void setupReporters() {
        this.setupJmxReporter();
        this.setupGraphiteReporter();
    }

    protected void setupJmxReporter() {
        logger.info("Initializing Metrics JMX Reporter");
        JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metrics).createsObjectNamesWith((ObjectNameFactory)new DefaultObjectNameFactory(){
            Pattern wildcards = Pattern.compile("[\\*\\?]");

            public ObjectName createName(String type, String domain, String name) {
                if (this.wildcards.matcher(name).find()) {
                    name = ObjectName.quote(name);
                }
                return super.createName(type, domain, name);
            }
        }).build();
        jmxReporter.start();
    }

    protected void setupGraphiteReporter() {
        if (this.graphiteSettings.getGraphiteHost().isPresent()) {
            InetSocketAddress address = new InetSocketAddress((String)this.graphiteSettings.getGraphiteHost().get(), (int)((Integer)this.graphiteSettings.getGraphitePort().or((Object)2003)));
            logger.info("Initializing Metrics Graphite reporting to {}", (Object)address);
            GraphiteReporter.Builder builder = GraphiteReporter.forRegistry((MetricRegistry)this.metrics);
            if (this.graphiteSettings.getPrefix().isPresent()) {
                String prefix = (String)this.graphiteSettings.getPrefix().get();
                builder.prefixedWith(prefix);
                logger.info("Metrics Graphite prefix is set to '{}'", (Object)prefix);
            }
            GraphiteReporter graphiteReporter = builder.convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(new Graphite(address));
            graphiteReporter.start((long)((Integer)this.graphiteSettings.getFrequency().get()).intValue(), TimeUnit.valueOf((String)this.graphiteSettings.getFrequencyUnit().get()));
        }
    }
}

