package restx.monitor;

import restx.common.ConfigElement;
import restx.config.ConfigSupplier;
import restx.common.RestxConfig;
import restx.common.StdRestxConfig;
import restx.factory.Component;

import static java.util.Arrays.asList;

@Component(priority = 1000)
public class GraphiteSettingsProvider implements ConfigSupplier {
    @Override
    public RestxConfig get() {
        return StdRestxConfig.of(asList(new ConfigElement[] {
                ConfigElement.of("restx.monitor.GraphiteSettings", "the host at which a graphite server is listening to collect metrics info - set it to activate graphite reporting", "restx.graphite.host", ""),
                ConfigElement.of("restx.monitor.GraphiteSettings", "the port at which a graphite server is listening to collect metrics info", "restx.graphite.port", ""),
                ConfigElement.of("restx.monitor.GraphiteSettings", "the frequency at which data is sent to graphite", "restx.graphite.reporter.frequency", "1"),
                ConfigElement.of("restx.monitor.GraphiteSettings", "the unit in which frequency is expressed", "restx.graphite.reporter.frequency.unit", "MINUTES"),
                ConfigElement.of("restx.monitor.GraphiteSettings", "the value prepended to all metrics names which are sent to graphite", "restx.graphite.prefix", ""),
        }
        ));
    }
}
