package restx.monitor;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.monitor.GraphiteSettingsConfig;

@Machine
public class GraphiteSettingsConfigFactoryMachine extends SingleNameFactoryMachine<restx.monitor.GraphiteSettingsConfig> {
    public static final Name<restx.monitor.GraphiteSettingsConfig> NAME = Name.of(restx.monitor.GraphiteSettingsConfig.class, "GraphiteSettingsConfig");

    public GraphiteSettingsConfigFactoryMachine() {
        super(0, new StdMachineEngine<restx.monitor.GraphiteSettingsConfig>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.common.RestxConfig> config = Factory.Query.byClass(restx.common.RestxConfig.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
config
                ));
            }

            @Override
            protected restx.monitor.GraphiteSettingsConfig doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new GraphiteSettingsConfig(
satisfiedBOM.getOne(config).get().getComponent()
                );
            }
        });
    }

}
