package restx.monitor;

import restx.common.RestxConfig;
import restx.factory.Component;

@Component
public class GraphiteSettingsConfig implements restx.monitor.GraphiteSettings {
    private final RestxConfig config;

    public GraphiteSettingsConfig(RestxConfig config) {
        this.config = config;
    }

    @Override
    public com.google.common.base.Optional<java.lang.String> getGraphiteHost() {
        return config.getString("restx.graphite.host");
    }

    @Override
    public com.google.common.base.Optional<java.lang.Integer> getGraphitePort() {
        return config.getInt("restx.graphite.port");
    }

    @Override
    public com.google.common.base.Optional<java.lang.Integer> getFrequency() {
        return config.getInt("restx.graphite.reporter.frequency");
    }

    @Override
    public com.google.common.base.Optional<java.lang.String> getFrequencyUnit() {
        return config.getString("restx.graphite.reporter.frequency.unit");
    }

    @Override
    public com.google.common.base.Optional<java.lang.String> getPrefix() {
        return config.getString("restx.graphite.prefix");
    }
}
