/*
 * Decompiled with CFR 0.152.
 */
package restx.monitor;

import com.google.common.collect.ImmutableSet;
import restx.AppSettings;
import restx.common.metrics.api.MetricRegistry;
import restx.common.metrics.api.health.HealthCheckRegistry;
import restx.factory.BillOfMaterials;
import restx.factory.BoundlessComponentBox;
import restx.factory.Factory;
import restx.factory.Machine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;
import restx.factory.SingleNameFactoryMachine;
import restx.factory.StdMachineEngine;
import restx.monitor.GraphiteSettings;
import restx.monitor.MetricsConfiguration;

@Machine
public class MetricsConfigurationFactoryMachine
extends SingleNameFactoryMachine<MetricsConfiguration> {
    public static final Name<MetricsConfiguration> NAME = Name.of(MetricsConfiguration.class, (String)"MetricsConfiguration");

    public MetricsConfigurationFactoryMachine() {
        super(0, (MachineEngine)new StdMachineEngine<MetricsConfiguration>(NAME, 0, BoundlessComponentBox.FACTORY){
            private final Factory.Query<MetricRegistry> metricRegistry = Factory.Query.byClass(MetricRegistry.class).mandatory();
            private final Factory.Query<HealthCheckRegistry> healthCheckRegistry = Factory.Query.byClass(HealthCheckRegistry.class).mandatory();
            private final Factory.Query<GraphiteSettings> graphiteSettings = Factory.Query.byClass(GraphiteSettings.class).mandatory();
            private final Factory.Query<AppSettings> appSettings = Factory.Query.byClass(AppSettings.class).mandatory();

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of(this.metricRegistry, this.healthCheckRegistry, this.graphiteSettings, this.appSettings));
            }

            protected MetricsConfiguration doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new MetricsConfiguration((MetricRegistry)((NamedComponent)satisfiedBOM.getOne(this.metricRegistry).get()).getComponent(), (HealthCheckRegistry)((NamedComponent)satisfiedBOM.getOne(this.healthCheckRegistry).get()).getComponent(), (GraphiteSettings)((NamedComponent)satisfiedBOM.getOne(this.graphiteSettings).get()).getComponent(), (AppSettings)((NamedComponent)satisfiedBOM.getOne(this.appSettings).get()).getComponent());
            }
        });
    }
}

