package restx.monitor;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.monitor.MetricsConfiguration;

@Machine
public class MetricsConfigurationFactoryMachine extends SingleNameFactoryMachine<restx.monitor.MetricsConfiguration> {
    public static final Name<restx.monitor.MetricsConfiguration> NAME = Name.of(restx.monitor.MetricsConfiguration.class, "MetricsConfiguration");

    public MetricsConfigurationFactoryMachine() {
        super(0, new StdMachineEngine<restx.monitor.MetricsConfiguration>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.common.metrics.api.MetricRegistry> metricRegistry = Factory.Query.byClass(restx.common.metrics.api.MetricRegistry.class).mandatory();
private final Factory.Query<restx.common.metrics.api.health.HealthCheckRegistry> healthCheckRegistry = Factory.Query.byClass(restx.common.metrics.api.health.HealthCheckRegistry.class).mandatory();
private final Factory.Query<restx.monitor.GraphiteSettings> graphiteSettings = Factory.Query.byClass(restx.monitor.GraphiteSettings.class).mandatory();
private final Factory.Query<restx.AppSettings> appSettings = Factory.Query.byClass(restx.AppSettings.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
metricRegistry,
healthCheckRegistry,
graphiteSettings,
appSettings
                ));
            }

            @Override
            protected restx.monitor.MetricsConfiguration doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new MetricsConfiguration(
satisfiedBOM.getOne(metricRegistry).get().getComponent(),
satisfiedBOM.getOne(healthCheckRegistry).get().getComponent(),
satisfiedBOM.getOne(graphiteSettings).get().getComponent(),
satisfiedBOM.getOne(appSettings).get().getComponent()
                );
            }
        });
    }

}
