/*
 * Decompiled with CFR 0.152.
 */
package restx.monitor;

import com.google.common.collect.ImmutableMap;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import java.io.IOException;
import java.util.Locale;
import restx.HttpStatus;
import restx.ResourcesRoute;
import restx.RestxContext;
import restx.RestxRequest;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouteMatch;
import restx.RestxRouteMatcher;
import restx.RestxRouter;
import restx.StdRoute;
import restx.StdRouteMatcher;
import restx.factory.Component;

@Component
public class MonitorRouter
extends RestxRouter {
    public MonitorRouter() {
        super("MonitorRouter", new RestxRoute[]{new ResourcesRoute("MonitorUIRoute", "/@/ui/monitor", MonitorRouter.class.getPackage().getName(), ImmutableMap.of((Object)"", (Object)"index.html")), new StdRoute("MonitorRoute", (RestxRouteMatcher)new StdRouteMatcher("GET", "/@/monitor")){

            public void handle(RestxRouteMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
                resp.setStatus(HttpStatus.OK.getCode());
                resp.setContentType("application/json");
                resp.getWriter().print("[");
                int i = 0;
                for (Monitor monitor : MonitorFactory.getRootMonitor().getMonitors()) {
                    if (monitor.getLabel().endsWith("/@/monitor")) continue;
                    if (i != 0) {
                        resp.getWriter().print(",");
                    }
                    resp.getWriter().print(String.format(Locale.ENGLISH, "{ \"id\": %s, \"label\": \"%s\", \"hits\": %.2f, \"avg\": %.2f, \"lastVal\": %.2f, \"min\": %.2f, \"max\": %.2f, \"active\": %.2f, \"avgActive\": %.2f, \"maxActive\": %.2f, \"firstAccess\": \"%tF %tT\", \"lastAccess\": \"%tF %tT\" }", i++, monitor.getLabel(), monitor.getHits(), monitor.getAvg(), monitor.getLastValue(), monitor.getMin(), monitor.getMax(), monitor.getActive(), monitor.getAvgActive(), monitor.getMaxActive(), monitor.getFirstAccess(), monitor.getFirstAccess(), monitor.getLastAccess(), monitor.getLastAccess()));
                }
                resp.getWriter().print("]");
            }
        }});
    }
}

