package restx.factory;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.factory.FactoryDumpRoute;

@Machine
public class FactoryDumpRouteFactoryMachine extends SingleNameFactoryMachine<restx.factory.FactoryDumpRoute> {
    public static final Name<restx.factory.FactoryDumpRoute> NAME = Name.of(restx.factory.FactoryDumpRoute.class, "FactoryDumpRoute");

    public FactoryDumpRouteFactoryMachine() {
        super(0, new StdMachineEngine<restx.factory.FactoryDumpRoute>(NAME, 0, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.factory.Factory> factory = Factory.Query.byClass(restx.factory.Factory.class).mandatory();
private final Factory.Query<restx.security.RestxSecurityManager> securityManager = Factory.Query.byClass(restx.security.RestxSecurityManager.class).mandatory();
private final Factory.Query<restx.security.PermissionFactory> permissionFactory = Factory.Query.byClass(restx.security.PermissionFactory.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
factory,
securityManager,
permissionFactory
                ));
            }

            @Override
            protected restx.factory.FactoryDumpRoute doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new FactoryDumpRoute(
satisfiedBOM.getOne(factory).get().getComponent(),
satisfiedBOM.getOne(securityManager).get().getComponent(),
satisfiedBOM.getOne(permissionFactory).get().getComponent()
                );
            }
        });
    }

}
