/*
 * Decompiled with CFR 0.152.
 */
package restx.factory;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.inject.Inject;
import restx.RestxContext;
import restx.RestxRequest;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouteMatch;
import restx.RestxRouteMatcher;
import restx.RestxRouter;
import restx.StdRoute;
import restx.StdRouteMatcher;
import restx.annotations.RestxResource;
import restx.converters.StringConverter;
import restx.factory.Component;
import restx.factory.Factory;
import restx.factory.Name;
import restx.factory.Warehouse;

@Component
public class WarehouseRoute
extends StdRoute {
    private final Warehouse warehouse;

    @Inject
    public WarehouseRoute(Factory factory) {
        this(factory.getWarehouse());
    }

    public WarehouseRoute(Warehouse warehouse) {
        super("WarehouseRoute", (RestxRouteMatcher)new StdRouteMatcher("GET", "/@/warehouse"));
        this.warehouse = warehouse;
    }

    public void handle(RestxRouteMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
        resp.setContentType("application/json");
        ArrayList nodesCode = Lists.newArrayList();
        ArrayList linksCode = Lists.newArrayList();
        for (Name name : this.warehouse.listNames()) {
            nodesCode.add(String.format("{ \"id\": \"%s\", \"name\": \"%s\", \"type\": \"%s\" }", name.asId(), name.getSimpleName(), this.getType(name)));
            Iterable deps = this.warehouse.listDependencies(name);
            for (Name dep : deps) {
                linksCode.add(String.format("{ \"origin\": \"%s\", \"target\": \"%s\" }", name.asId(), dep.asId()));
            }
        }
        PrintWriter writer = resp.getWriter();
        writer.println("{");
        writer.println("\"nodes\": [");
        Joiner.on((String)",\n").appendTo((Appendable)writer, (Iterable)nodesCode);
        writer.println("\n],");
        writer.println("\"links\": [");
        Joiner.on((String)",\n").appendTo((Appendable)writer, (Iterable)linksCode);
        writer.println("\n]");
        writer.println("}");
    }

    private String getType(Name<?> name) {
        if (RestxRouter.class.isAssignableFrom(name.getClazz())) {
            return RestxRouter.class.getSimpleName();
        }
        if (RestxRoute.class.isAssignableFrom(name.getClazz())) {
            return RestxRoute.class.getSimpleName();
        }
        if (StringConverter.class.isAssignableFrom(name.getClazz())) {
            return StringConverter.class.getSimpleName();
        }
        if (name.getClazz().getName().endsWith("Resource")) {
            return RestxResource.class.getSimpleName();
        }
        return name.getClazz().getSimpleName();
    }
}

