package restx.factory;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.factory.WarehouseRoute;

@Machine
public class WarehouseRouteFactoryMachine extends SingleNameFactoryMachine<WarehouseRoute> {
    public static final Name<WarehouseRoute> NAME = Name.of(WarehouseRoute.class, "WarehouseRoute");

    public WarehouseRouteFactoryMachine() {
        super(0, new StdMachineEngine<WarehouseRoute>(NAME, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.factory.Factory> factory = Factory.Query.byClass(restx.factory.Factory.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
factory
                ));
            }

            @Override
            protected WarehouseRoute doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new WarehouseRoute(
satisfiedBOM.getOne(factory).get().getComponent()
                );
            }
        });
    }

}
