package restx.factory;

import com.google.common.collect.ImmutableSet;
import restx.factory.*;
import restx.factory.FactoryDumpRoute;

@Machine
public class FactoryDumpRouteFactoryMachine extends SingleNameFactoryMachine<FactoryDumpRoute> {
    public static final Name<FactoryDumpRoute> NAME = Name.of(FactoryDumpRoute.class, "FactoryDumpRoute");

    public FactoryDumpRouteFactoryMachine() {
        super(0, new StdMachineEngine<FactoryDumpRoute>(NAME, BoundlessComponentBox.FACTORY) {
private final Factory.Query<restx.factory.Factory> factory = Factory.Query.byClass(restx.factory.Factory.class).mandatory();

            @Override
            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.<Factory.Query<?>>of(
factory
                ));
            }

            @Override
            protected FactoryDumpRoute doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new FactoryDumpRoute(
satisfiedBOM.getOne(factory).get().getComponent()
                );
            }
        });
    }

}
