/*
 * Decompiled with CFR 0.152.
 */
package restx.build;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import restx.build.GAV;
import restx.build.ModuleDependency;
import restx.build.ModuleFragment;

public class ModuleDescriptor {
    private final GAV parent;
    private final GAV gav;
    private final String packaging;
    private final Map<String, String> properties;
    private final List<String> propertiesFileReferences;
    private final Map<String, List<ModuleFragment>> fragments;
    private final Map<String, List<ModuleDependency>> dependencies;
    private final ModuleDescriptor parsedModuleDescriptor;

    public ModuleDescriptor(GAV parent, GAV gav, String packaging, Map<String, String> properties, List<String> propertiesFileReferences, Map<String, List<ModuleFragment>> fragments, Map<String, List<ModuleDependency>> dependencies, ModuleDescriptor parsedModuleDescriptor) {
        this.parent = parent;
        this.gav = gav;
        this.packaging = packaging;
        this.propertiesFileReferences = propertiesFileReferences;
        this.fragments = Collections.unmodifiableMap(fragments);
        this.properties = Collections.unmodifiableMap(properties);
        this.dependencies = Collections.unmodifiableMap(dependencies);
        this.parsedModuleDescriptor = parsedModuleDescriptor;
    }

    public GAV getParent() {
        return this.parent;
    }

    public GAV getGav() {
        return this.gav;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Set<String> getDependencyScopes() {
        return this.dependencies.keySet();
    }

    public List<ModuleDependency> getDependencies(String scope) {
        return this.dependencies.get(scope);
    }

    public Set<String> getFragmentTypes() {
        return this.fragments.keySet();
    }

    public List<ModuleFragment> getFragments(String s) {
        List<ModuleFragment> moduleFragments = this.fragments.get(s);
        return moduleFragments == null ? Collections.emptyList() : moduleFragments;
    }

    public ModuleDescriptor concatDependency(String scope, ModuleDependency dep) {
        LinkedHashMap<String, List<ModuleDependency>> newDeps = new LinkedHashMap<String, List<ModuleDependency>>(this.dependencies);
        if (!newDeps.containsKey(scope)) {
            newDeps.put(scope, new ArrayList());
        } else {
            newDeps.put(scope, new ArrayList(newDeps.get(scope)));
        }
        newDeps.get(scope).add(dep);
        return new ModuleDescriptor(this.parent, this.gav, this.packaging, this.properties, this.propertiesFileReferences, this.fragments, newDeps, this.parsedModuleDescriptor);
    }

    public boolean hasClassifier() {
        for (String scope : this.getDependencyScopes()) {
            for (ModuleDependency dependency : this.getDependencies(scope)) {
                if (dependency.getGav().getClassifier() == null) continue;
                return true;
            }
        }
        return false;
    }

    public ModuleDescriptor getParsedModuleDescriptor() {
        return this.parsedModuleDescriptor == null ? this : this.parsedModuleDescriptor;
    }

    public List<String> getPropertiesFileReferences() {
        return this.propertiesFileReferences;
    }
}

