/*
 * Decompiled with CFR 0.152.
 */
package restx.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GAV {
    private static final String OPTIONAL_SUFFIX = "!optional";
    private static final Pattern EXCLUSIONS_SUFFIX = Pattern.compile("(.*)!excluding\\(([^)]+)\\)(.*)");
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String type;
    private final String classifier;
    private final boolean optional;
    private final List<Exclusion> exclusions;

    public GAV(String groupId, String artifactId, String version, boolean optional) {
        this(groupId, artifactId, version, null, null, optional);
    }

    public GAV(String groupId, String artifactId, String version, String type, boolean optional) {
        this(groupId, artifactId, version, type, null, optional);
    }

    public GAV(String groupId, String artifactId, String version, String type, String classifier, boolean optional) {
        this(groupId, artifactId, version, type, classifier, optional, null);
    }

    public GAV(String groupId, String artifactId, String version, String type, String classifier, boolean optional, List<Exclusion> exclusions) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
        this.optional = optional;
        this.exclusions = exclusions;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public List<Exclusion> getExclusions() {
        return this.exclusions;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GAV gav = (GAV)o;
        if (this.optional != gav.optional) {
            return false;
        }
        if (!this.groupId.equals(gav.groupId)) {
            return false;
        }
        if (!this.artifactId.equals(gav.artifactId)) {
            return false;
        }
        if (!this.version.equals(gav.version)) {
            return false;
        }
        if (this.type != null ? !this.type.equals(gav.type) : gav.type != null) {
            return false;
        }
        if (this.classifier != null ? !this.classifier.equals(gav.classifier) : gav.classifier != null) {
            return false;
        }
        return this.exclusions != null ? this.exclusions.equals(gav.exclusions) : gav.exclusions == null;
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 31 * result + (this.optional ? 1 : 0);
        result = 31 * result + (this.exclusions != null ? this.exclusions.hashCode() : 0);
        return result;
    }

    public String toParseableString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.groupId + ":" + this.artifactId + ":" + this.version);
        if (this.type != null) {
            builder.append(":" + this.type);
            if (this.classifier != null) {
                builder.append(":" + this.classifier);
            }
        }
        if (this.optional) {
            builder.append(OPTIONAL_SUFFIX);
        }
        if (this.exclusions != null) {
            builder.append("!excluding(");
            for (Exclusion exclusion : this.exclusions) {
                builder.append(exclusion).append(",");
            }
            builder.setCharAt(builder.length() - 1, ')');
        }
        return builder.toString();
    }

    public static GAV parse(String gav) {
        String[] parts;
        Matcher exclusionsMatcher;
        Builder gavBuilder = GAV.builder();
        if (gav.contains(OPTIONAL_SUFFIX)) {
            gavBuilder.opt(true);
            gav = gav.replace(OPTIONAL_SUFFIX, "");
        }
        if ((exclusionsMatcher = EXCLUSIONS_SUFFIX.matcher(gav)).matches()) {
            List<Exclusion> exclusions = Exclusion.parse(exclusionsMatcher.group(2));
            gavBuilder.excl(exclusions.toArray(new Exclusion[0]));
            gav = gav.replaceAll(EXCLUSIONS_SUFFIX.pattern(), "$1$3");
        }
        if ((parts = gav.split(":")).length < 3 || parts.length > 5) {
            throw new IllegalArgumentException("can't parse '" + gav + "' as a module coordinates (GAV). " + "It must have at least 3 parts separated by columns. (4th and 5th are optional and correspond to artifact type and classifier)");
        }
        gavBuilder.g(parts[0]).a(parts[1]).v(parts[2]);
        if (parts.length >= 4) {
            gavBuilder.t(parts[3]);
        }
        if (parts.length >= 5) {
            gavBuilder.c(parts[4]);
        }
        return gavBuilder.create();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String groupId;
        private String artifactId;
        private String version;
        private String type;
        private String classifier;
        private boolean optional = false;
        private List<Exclusion> exclusions = null;

        public Builder g(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder a(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder v(String version) {
            this.version = version;
            return this;
        }

        public Builder t(String type) {
            this.type = type;
            return this;
        }

        public Builder c(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public Builder opt(boolean optional) {
            this.optional = optional;
            return this;
        }

        public Builder excl(Exclusion ... exclusions) {
            this.exclusions = Arrays.asList(exclusions);
            return this;
        }

        public GAV create() {
            return new GAV(this.groupId, this.artifactId, this.version, this.type, this.classifier, this.optional, this.exclusions);
        }
    }

    public static class Exclusion {
        private final String groupId;
        private final String artifactId;

        public Exclusion(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Exclusion exclusion = (Exclusion)o;
            if (this.groupId != null ? !this.groupId.equals(exclusion.groupId) : exclusion.groupId != null) {
                return false;
            }
            return this.artifactId != null ? this.artifactId.equals(exclusion.artifactId) : exclusion.artifactId == null;
        }

        public int hashCode() {
            int result = this.groupId != null ? this.groupId.hashCode() : 0;
            result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.groupId + ':' + this.artifactId;
        }

        public static List<Exclusion> parse(String str) {
            String[] exclusionsStr = str.split(",");
            ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
            for (int i = 0; i < exclusionsStr.length; ++i) {
                String[] parts = exclusionsStr[i].split(":");
                exclusions.add(new Exclusion(parts[0], parts[1]));
            }
            return exclusions;
        }
    }
}

